/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.extension.api.runtime.source;

import java.util.Optional;

/**
 * A context interface to correlate a message generated by a {@link Source} to
 * a particular state
 *
 * @since 1.0
 */
public interface SourceCallbackContext {

  /**
   * Returns whether a variable of name {@code variableName} has a value associated to it
   * through the {@link #addVariable(String, Object)} method
   *
   * @param variableName the name of a variable associated to a particular {@link SourceCallback}
   * @return {@code true} if the parameter is present.
   */
  boolean hasVariable(String variableName);

  /**
   * Returns the value associated to a variable of name {@code variableName}
   *
   * @param variableName the name of a variable of a {@link SourceCallback}
   * @param <T>          the returned value's generic type
   * @return an {@link Optional} of the variable's value.
   */
  <T> Optional<T> getVariable(String variableName);

  /**
   * Adds a variable
   *
   * @param variableName the name of the variable
   * @param value        the variable's value
   */
  void addVariable(String variableName, Object value);

  /**
   * @param <T> the generic type of the output values of the generated results
   * @param <A> the generic type of the attributes of the generated results
   * @return The {@link SourceCallback} that generated {@code this} context
   */
  <T, A> SourceCallback<T, A> getSourceCallback();
}
