/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.VoidType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;

public final class TargetParameterDeclarationEnricher
implements DeclarationEnricher {
    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        new EnricherDelegate().enrich(extensionLoadingContext);
    }

    private class EnricherDelegate
    implements DeclarationEnricher {
        private MetadataType attributeType = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader().load(String.class);

        private EnricherDelegate() {
        }

        @Override
        public void enrich(ExtensionLoadingContext extensionLoadingContext) {
            new IdempotentDeclarationWalker(){

                @Override
                protected void onOperation(OperationDeclaration declaration) {
                    MetadataType outputType = declaration.getOutput().getType();
                    if (outputType == null) {
                        throw new IllegalOperationModelDefinitionException(String.format("Operation '%s' does not specify an output type", declaration.getName()));
                    }
                    if (!(outputType instanceof VoidType)) {
                        ParameterDeclaration parameter = new ParameterDeclaration("target");
                        parameter.setDescription("The name of a variable on which the operation's output will be placed");
                        parameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
                        parameter.setRequired(false);
                        parameter.setParameterRole(ParameterRole.BEHAVIOUR);
                        parameter.setType(EnricherDelegate.this.attributeType, false);
                        parameter.setDisplayModel(DisplayModel.builder().displayName("Target Variable").build());
                        parameter.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
                        declaration.getParameterGroup("Output").addParameter(parameter);
                    }
                }
            }.walk((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
        }
    }
}

