/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validator;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.extension.internal.property.TransactionalActionModelProperty;

public final class TransactionalParametersValidator
implements ExtensionModelValidator {
    @Override
    public void validate(final ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
        new IdempotentExtensionWalker(){

            protected void onSource(SourceModel sourceModel) {
                if (sourceModel.isTransactional()) {
                    TransactionalParametersValidator.this.validateTransactionalParameters((ComponentModel)sourceModel, problemsReporter, extensionModel);
                }
            }

            protected void onOperation(OperationModel operationModel) {
                if (operationModel.isTransactional()) {
                    TransactionalParametersValidator.this.validateTransactionalParameters((ComponentModel)operationModel, problemsReporter, extensionModel);
                }
            }
        }.walk(extensionModel);
    }

    private void validateTransactionalParameters(ComponentModel componentModel, ProblemsReporter problemsReporter, ExtensionModel extensionModel) {
        List parameters = componentModel.getParameterGroupModels().stream().map(group -> group.getParameterModels().stream().map(param -> Pair.of((Object)param, (Object)group))).flatMap(stream -> stream).collect(Collectors.toList());
        parameters.stream().filter(pair -> ((ParameterModel)pair.getKey()).getModelProperty(TransactionalActionModelProperty.class).isPresent()).forEach(pair -> {
            if (((ParameterGroupModel)pair.getValue()).isShowInDsl()) {
                problemsReporter.addError(new Problem((NamedObject)componentModel, "The " + NameUtils.getComponentModelTypeName(componentModel) + " [" + componentModel.getName() + "] defines the parameter [" + ((ParameterModel)pair.getKey()).getName() + "] which is a TransactionalAction. Transactional parameters can't be placed inside of Parameter Groups with 'showInDsl' option."));
            }
        });
        parameters.stream().filter(pair -> ((ParameterModel)pair.getKey()).getName().equals("transactionalAction")).findFirst().ifPresent(pair -> {
            if (!((ParameterModel)pair.getKey()).getModelProperty(TransactionalActionModelProperty.class).isPresent()) {
                problemsReporter.addError(new Problem((NamedObject)componentModel, "The " + NameUtils.getComponentModelTypeName(componentModel) + " [" + componentModel.getName() + "] defines a parameter named: '" + "transactionalAction" + "', which is a reserved word"));
            }
        });
    }
}

