/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.declaration;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.VoidType;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ExternalLibraryModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.FunctionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.tck.TestWebServiceConsumerDeclarer;
import org.mule.runtime.extension.api.declaration.BaseDeclarationTestCase;

@RunWith(value=MockitoJUnitRunner.class)
public class FlatExtensionDeclarationTestCase
extends BaseDeclarationTestCase {
    private TestWebServiceConsumerDeclarer testDeclaration;
    private ExtensionDeclaration extensionDeclaration;

    @Before
    public void before() {
        this.testDeclaration = new TestWebServiceConsumerDeclarer();
        this.extensionDeclaration = (ExtensionDeclaration)this.testDeclaration.getExtensionDeclarer().getDeclaration();
    }

    @Test
    public void assertDeclaration() {
        Assert.assertThat((Object)this.extensionDeclaration.getName(), (Matcher)CoreMatchers.is((Object)"WSConsumer"));
        Assert.assertThat((Object)this.extensionDeclaration.getDescription(), (Matcher)CoreMatchers.is((Object)"Generic Consumer for SOAP Web Services"));
        Assert.assertThat((Object)this.extensionDeclaration.getVersion(), (Matcher)CoreMatchers.is((Object)"3.6.0"));
        Assert.assertThat((Object)this.extensionDeclaration.getConfigurations(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)this.extensionDeclaration.getVendor(), (Matcher)CoreMatchers.is((Object)"MuleSoft"));
        Assert.assertThat((Object)this.extensionDeclaration.getMinMuleVersion(), (Matcher)CoreMatchers.is((Object)TestWebServiceConsumerDeclarer.MIN_MULE_VERSION));
        Assert.assertThat((Object)this.extensionDeclaration.getCategory(), (Matcher)CoreMatchers.is((Object)Category.SELECT));
        this.assertExternalLibraries(this.extensionDeclaration.getExternalLibraryModels());
        this.assertModelProperties((BaseDeclaration<?>)this.extensionDeclaration, TestWebServiceConsumerDeclarer.EXTENSION_MODEL_PROPERTY);
    }

    @Test
    public void defaultConfiguration() throws Exception {
        Assert.assertThat((Object)this.extensionDeclaration.getConfigurations(), (Matcher)Matchers.hasSize((int)1));
        ConfigurationDeclaration configuration = (ConfigurationDeclaration)this.extensionDeclaration.getConfigurations().get(0);
        Assert.assertThat((Object)configuration, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)configuration.getName(), (Matcher)CoreMatchers.is((Object)"config"));
        Assert.assertThat((Object)configuration.getDescription(), (Matcher)CoreMatchers.is((Object)"Default description"));
        this.assertModelProperties((BaseDeclaration<?>)configuration, TestWebServiceConsumerDeclarer.CONFIGURATION_MODEL_PROPERTY);
        List<ParameterDeclaration> parameters = this.assertGroupAndGetParameters((ParameterizedDeclaration)configuration, "Config parameters");
        Assert.assertThat(parameters, (Matcher)Matchers.hasSize((int)4));
        this.assertParameter(parameters.get(0), "address", "Service address", ExpressionSupport.SUPPORTED, true, this.typeLoader.load(String.class), null);
        this.assertParameter(parameters.get(1), "port", "Service Port", ExpressionSupport.SUPPORTED, true, this.typeLoader.load(String.class), null);
        this.assertParameter(parameters.get(2), "service", "Service Name", ExpressionSupport.SUPPORTED, true, this.typeLoader.load(String.class), null);
        this.assertParameter(parameters.get(3), "wsdlLocation", "URI to find the WSDL", ExpressionSupport.NOT_SUPPORTED, true, this.typeLoader.load(String.class), null);
        this.assertExternalLibraries(configuration.getExternalLibraryModels());
        this.assertModelProperties((BaseDeclaration)parameters.get(3), TestWebServiceConsumerDeclarer.PARAMETER_MODEL_PROPERTY);
    }

    @Test
    public void operations() throws Exception {
        List operations = this.extensionDeclaration.getOperations();
        Assert.assertThat((Object)operations, (Matcher)Matchers.hasSize((int)3));
        this.assertArgLessOperation(operations);
        this.assertBroadcastOperation(operations);
        this.assertConsumeOperation(operations);
    }

    @Test
    public void functions() throws Exception {
        List functions = this.extensionDeclaration.getFunctions();
        Assert.assertThat((Object)functions, (Matcher)Matchers.hasSize((int)1));
        FunctionDeclaration function = (FunctionDeclaration)functions.get(0);
        Assert.assertThat((Object)function.getName(), (Matcher)CoreMatchers.is((Object)"function"));
        Assert.assertThat((Object)function.getDescription(), (Matcher)CoreMatchers.is((Object)"sample function"));
        this.assertDataType(function.getOutput().getType(), Integer.class, NumberType.class);
        List<ParameterDeclaration> parameters = this.assertGroupAndGetParameters((ParameterizedDeclaration)function, "General");
        Assert.assertThat(parameters, (Matcher)Matchers.hasSize((int)1));
        this.assertParameter(parameters.get(0), "username", "Authentication username", ExpressionSupport.SUPPORTED, true, this.typeLoader.load(String.class), null);
    }

    @Test
    public void connectionProvider() throws Exception {
        List connectionProviders = this.extensionDeclaration.getConnectionProviders();
        Assert.assertThat((Object)connectionProviders, (Matcher)Matchers.hasSize((int)1));
        ConnectionProviderDeclaration connectionProvider = (ConnectionProviderDeclaration)connectionProviders.get(0);
        Assert.assertThat((Object)connectionProvider, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)connectionProvider.getName(), (Matcher)CoreMatchers.is((Object)"connectionProvider"));
        Assert.assertThat((Object)connectionProvider.getDescription(), (Matcher)CoreMatchers.is((Object)"my connection provider"));
        this.assertExternalLibraries(connectionProvider.getExternalLibraryModels());
        List<ParameterDeclaration> parameters = this.assertGroupAndGetParameters((ParameterizedDeclaration)connectionProvider, "Connection Provider parameters");
        Assert.assertThat(parameters, (Matcher)Matchers.hasSize((int)2));
        this.assertParameter(parameters.get(0), "username", "Authentication username", ExpressionSupport.SUPPORTED, true, this.typeLoader.load(String.class), null);
        this.assertParameter(parameters.get(1), "password", "Authentication password", ExpressionSupport.SUPPORTED, true, this.typeLoader.load(String.class), null);
    }

    @Test
    public void messageSource() throws Exception {
        List sources = this.extensionDeclaration.getMessageSources();
        Assert.assertThat((Object)sources, (Matcher)Matchers.hasSize((int)1));
        SourceDeclaration source = (SourceDeclaration)sources.get(0);
        Assert.assertThat((Object)source, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)source.getName(), (Matcher)CoreMatchers.is((Object)"listener"));
        Assert.assertThat((Object)source.getDescription(), (Matcher)CoreMatchers.is((Object)"Listen requests"));
        this.assertDataType(source.getOutput().getType(), InputStream.class, BinaryType.class);
        this.assertDataType(source.getOutputAttributes().getType(), Serializable.class, ObjectType.class);
        List<ParameterDeclaration> parameters = this.assertGroupAndGetParameters((ParameterizedDeclaration)source, "Source parameters");
        Assert.assertThat(parameters, (Matcher)Matchers.hasSize((int)2));
        this.assertParameter(parameters.get(0), "url", "Url to listen on", ExpressionSupport.SUPPORTED, true, this.typeLoader.load(String.class), null);
        this.assertParameter(parameters.get(1), "port", "Port to listen on", ExpressionSupport.SUPPORTED, false, this.typeLoader.load(Integer.class), 8080);
    }

    private void assertConsumeOperation(List<OperationDeclaration> operations) {
        OperationDeclaration operation = operations.get(2);
        Assert.assertThat((Object)operation.getName(), (Matcher)CoreMatchers.is((Object)"consumer"));
        Assert.assertThat((Object)operation.getDescription(), (Matcher)CoreMatchers.is((Object)"Go get them tiger"));
        this.assertDataType(operation.getOutput().getType(), InputStream.class, BinaryType.class);
        this.assertDataType(operation.getOutputAttributes().getType(), String.class, StringType.class);
        this.assertModelProperties((BaseDeclaration<?>)operation, TestWebServiceConsumerDeclarer.OPERATION_MODEL_PROPERTY);
        List<ParameterDeclaration> parameters = this.assertGroupAndGetParameters((ParameterizedDeclaration)operation, "Operation parameters");
        Assert.assertThat(parameters, (Matcher)Matchers.hasSize((int)2));
        this.assertParameter(parameters.get(0), "operation", "The operation to use", ExpressionSupport.SUPPORTED, true, this.typeLoader.load(String.class), null);
        this.assertParameter(parameters.get(1), "mtomEnabled", "Whether or not use MTOM for attachments", ExpressionSupport.SUPPORTED, false, this.typeLoader.load(Boolean.class), true);
    }

    private void assertBroadcastOperation(List<OperationDeclaration> operations) {
        OperationDeclaration operation = operations.get(1);
        Assert.assertThat((Object)operation.getName(), (Matcher)CoreMatchers.is((Object)"broadcast"));
        Assert.assertThat((Object)operation.getDescription(), (Matcher)CoreMatchers.is((Object)"consumes many services"));
        this.assertDataType(operation.getOutput().getType(), Void.TYPE, VoidType.class);
        List<ParameterDeclaration> parameters = this.assertGroupAndGetParameters((ParameterizedDeclaration)operation, "Operation parameters");
        Assert.assertThat(parameters, (Matcher)Matchers.hasSize((int)3));
        this.assertParameter(parameters.get(0), "things", "The operation to use", ExpressionSupport.SUPPORTED, true, (MetadataType)this.typeBuilder.arrayType().of((TypeBuilder)this.typeBuilder.stringType()).build(), null);
        this.assertParameter(parameters.get(1), "mtomEnabled", "Whether or not use MTOM for attachments", ExpressionSupport.SUPPORTED, false, this.typeLoader.load(Boolean.class), true);
        this.assertParameter(parameters.get(2), "callback", "async callback", ExpressionSupport.REQUIRED, true, this.typeLoader.load(OperationModel.class), null);
    }

    private void assertArgLessOperation(List<OperationDeclaration> operations) {
        OperationDeclaration operation = operations.get(0);
        Assert.assertThat((Object)operation.getName(), (Matcher)CoreMatchers.is((Object)"argLess"));
        Assert.assertThat((Object)operation.getDescription(), (Matcher)CoreMatchers.is((Object)"has no args"));
        this.assertDataType(operation.getOutput().getType(), Integer.class, NumberType.class);
        List parameterGroups = operation.getParameterGroups();
        Assert.assertThat((Object)parameterGroups, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)parameterGroups.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        List parameters = operation.getAllParameters();
        Assert.assertThat((Object)parameters, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)parameters.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    private void assertModelProperties(BaseDeclaration<?> declaration, ModelProperty ... modelProperty) {
        List<ModelProperty> expected = Arrays.asList(modelProperty);
        Set properties = declaration.getModelProperties();
        Assert.assertThat((Object)properties, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)properties.size(), (Matcher)CoreMatchers.is((Object)expected.size()));
        expected.forEach(mp -> {
            Assert.assertThat((Object)properties.contains(mp), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat(declaration.getModelProperty(mp.getClass()).get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)mp)));
        });
    }

    private List<ParameterDeclaration> assertGroupAndGetParameters(ParameterizedDeclaration declaration, String groupName) {
        List groupDeclarations = declaration.getParameterGroups();
        Assert.assertThat((Object)groupDeclarations, (Matcher)Matchers.hasSize((int)1));
        ParameterGroupDeclaration groupDeclaration = (ParameterGroupDeclaration)groupDeclarations.get(0);
        Assert.assertThat((Object)groupDeclaration.getName(), (Matcher)CoreMatchers.is((Object)groupName));
        return groupDeclaration.getParameters();
    }

    private void assertExternalLibraries(Set<ExternalLibraryModel> externalLibraryModels) {
        Assert.assertThat(externalLibraryModels, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat(externalLibraryModels, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)externalLibraryModels.iterator().next(), (Matcher)CoreMatchers.is((Object)TestWebServiceConsumerDeclarer.EXTERNAL_LIBRARY_MODEL));
    }
}

