/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.declaration.type;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Ignore;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;

public final class TypeUtils {
    private TypeUtils() {
    }

    public static Collection<Field> getParameterFields(Class<?> declaringType) {
        return TypeUtils.getAllFields(declaringType).stream().filter(field -> (field.getAnnotation(Parameter.class) != null || field.getAnnotation(ParameterGroup.class) != null) && field.getAnnotation(Ignore.class) == null).collect(Collectors.toList());
    }

    public static Collection<Field> getAllFields(Class<?> declaringType) {
        return TypeUtils.getAllSuperClasses(declaringType).stream().flatMap(type -> Stream.of(type.getDeclaredFields())).collect(Collectors.toList());
    }

    public static Collection<Class<?>> getAllSuperClasses(Class<?> type) {
        LinkedList result = new LinkedList();
        if (type != null && !type.equals(Object.class)) {
            result.add(type);
            result.addAll(TypeUtils.getAllSuperClasses(type.getSuperclass()));
        }
        return result;
    }

    public static String getAlias(Field field) {
        Alias alias = field.getAnnotation(Alias.class);
        String name = alias != null ? alias.value() : null;
        return name == null || name.length() == 0 ? field.getName() : name;
    }
}

