/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.loader;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.loader.Problem;

public final class ProblemsReporter {
    private final ExtensionModel extensionModel;
    private final List<Problem> errors = new LinkedList<Problem>();
    private final List<Problem> warnings = new LinkedList<Problem>();

    public ProblemsReporter(ExtensionModel extensionModel) {
        this.extensionModel = extensionModel;
    }

    public ProblemsReporter addError(Problem problem) {
        this.errors.add(problem);
        return this;
    }

    public ProblemsReporter addWarning(Problem problem) {
        this.warnings.add(problem);
        return this;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public boolean hasWarnings() {
        return !this.errors.isEmpty();
    }

    public ExtensionModel getExtensionModel() {
        return this.extensionModel;
    }

    public List<Problem> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public List<Problem> getWarnings() {
        return Collections.unmodifiableList(this.warnings);
    }

    public String getWarningsAsString() {
        return this.appendProblems(new StringBuilder(), this.warnings).toString();
    }

    public String toString() {
        StringBuilder message = new StringBuilder();
        this.append(message, "ERRORS", this.errors);
        message.append('\n');
        this.append(message, "WARNINGS", this.warnings);
        return message.toString();
    }

    private void append(StringBuilder message, String problemType, Collection<Problem> problems) {
        message.append(problemType + ":");
        if (problems.isEmpty()) {
            message.append(" NONE");
        } else {
            message.append("\n");
            this.appendProblems(message, problems);
        }
    }

    private StringBuilder appendProblems(StringBuilder message, Collection<Problem> problems) {
        problems.forEach(p -> message.append("\t* ").append(p.getMessage()).append('\n'));
        return message;
    }
}

