/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.dsl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.extension.api.declaration.type.annotation.TypeDslAnnotation;
import org.mule.runtime.extension.api.dsl.BaseXmlDeclarationTestCase;
import org.mule.runtime.extension.api.dsl.model.AbstractType;
import org.mule.runtime.extension.api.dsl.model.ChildOfAbstractType;
import org.mule.runtime.extension.api.dsl.model.ComplexFieldsType;
import org.mule.runtime.extension.api.dsl.model.ExtensibleType;
import org.mule.runtime.extension.api.dsl.model.GlobalType;
import org.mule.runtime.extension.api.dsl.model.InterfaceDeclaration;
import org.mule.runtime.extension.api.dsl.model.InterfaceDeclarationWithMapping;
import org.mule.runtime.extension.api.dsl.model.InterfaceImplementation;
import org.mule.runtime.extension.api.dsl.model.NonDefaultConstructor;
import org.mule.runtime.extension.api.dsl.model.SimpleFieldsType;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.api.util.NameUtils;

@RunWith(value=Parameterized.class)
public class ParameterXmlDeclarationTestCase
extends BaseXmlDeclarationTestCase {
    public ParameterXmlDeclarationTestCase(ParameterRole role) {
        super(role);
    }

    @Test
    public void testStringTypeParameter() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(String.class));
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.ifNotContentParameter(() -> {
            this.assertAttributeName("myCamelCaseName", result);
            this.assertTopLevelDeclarationSupportIs(false, result);
            this.assertChildElementDeclarationIs(false, result);
        });
        this.assertChildElementDeclarationIs(ExtensionModelUtils.isContent((ParameterModel)this.parameterModel), result);
        this.assertIsWrappedElement(false, result);
    }

    @Test
    public void testSimpleTypeParameter() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(Integer.class));
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.ifNotContentParameter(() -> {
            this.assertAttributeName("myCamelCaseName", result);
            this.assertTopLevelDeclarationSupportIs(false, result);
            this.assertChildElementDeclarationIs(false, result);
        });
        this.assertChildElementDeclarationIs(ExtensionModelUtils.isContent((ParameterModel)this.parameterModel), result);
        this.assertIsWrappedElement(false, result);
    }

    @Test
    public void testSimplePojoParameter() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(SimpleFieldsType.class));
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        String fieldName = "sampleString";
        this.ifContentParameter(() -> Assert.assertThat((Object)result.getChild(fieldName).isPresent(), (Matcher)CoreMatchers.is((Object)false)), () -> {
            DslElementSyntax childDsl = this.getAttributeDsl(fieldName, result);
            this.assertAttributeName(fieldName, childDsl);
            this.assertParameterChildElementDeclaration(true, result);
            this.assertIsWrappedElement(false, result);
        });
    }

    @Test
    public void testComplexPojoParameter() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(ComplexFieldsType.class));
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertElementName(NameUtils.hyphenize((String)"myCamelCaseName"), result);
        this.assertElementPrefix("mockns", result);
        this.assertParameterChildElementDeclaration(true, result);
        this.assertIsWrappedElement(false, result);
        this.ifContentParameter(() -> Assert.assertThat((Object)result.getChild("extensibleTypeList").isPresent(), (Matcher)CoreMatchers.is((Object)false)), () -> {
            this.assertAttributeName("myCamelCaseName", result);
            this.assertComplexTypeDslFields(result);
        });
    }

    @Test
    public void xmlStyleAtParameterLevel() {
        ParameterDslConfiguration dslModel = ParameterDslConfiguration.builder().allowsInlineDefinition(false).allowTopLevelDefinition(false).allowsReferences(false).build();
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(String.class));
        Mockito.when((Object)this.parameterModel.getDslConfiguration()).thenReturn((Object)dslModel);
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertChildElementDeclarationIs(ExtensionModelUtils.isContent((ParameterModel)this.parameterModel), result);
    }

    @Test
    public void xmlStyleAtTypeLevel() {
        ParameterDslConfiguration dslModel = ParameterDslConfiguration.builder().allowsInlineDefinition(false).allowTopLevelDefinition(false).allowsReferences(false).build();
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.stringType().with((TypeAnnotation)new TypeDslAnnotation(false, false, "", "")).build());
        Mockito.when((Object)this.parameterModel.getDslConfiguration()).thenReturn((Object)dslModel);
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertChildElementDeclarationIs(ExtensionModelUtils.isContent((ParameterModel)this.parameterModel), result);
    }

    @Test
    public void topLevelType() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(GlobalType.class));
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertParameterChildElementDeclaration(true, result);
        this.assertIsWrappedElement(false, result);
        this.assertTopElementDeclarationIs(true, result);
    }

    @Test
    public void testExtensibleTypeParameter() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(ExtensibleType.class));
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertParameterChildElementDeclaration(true, result);
        this.assertIsWrappedElement(true, result);
    }

    @Test
    public void testInterfaceTypeParameter() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(InterfaceDeclaration.class));
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertParameterChildElementDeclaration(false, result);
        this.assertIsWrappedElement(false, result);
    }

    @Test
    public void testAbstractClassParameter() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(AbstractType.class));
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertParameterChildElementDeclaration(false, result);
        this.assertIsWrappedElement(false, result);
    }

    @Test
    public void testNonDefaultConstructorParameter() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(NonDefaultConstructor.class));
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertParameterChildElementDeclaration(false, result);
        this.assertIsWrappedElement(false, result);
    }

    @Test
    public void testInterfaceWithMappingParameter() {
        ObjectType baseType = (ObjectType)this.TYPE_LOADER.load(InterfaceDeclarationWithMapping.class);
        Mockito.when((Object)this.typeCatalog.containsBaseType(baseType)).thenReturn((Object)true);
        Mockito.when((Object)this.typeCatalog.getSubTypes(baseType)).thenReturn(Collections.singleton((ObjectType)this.TYPE_LOADER.load(InterfaceImplementation.class)));
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)baseType);
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertParameterChildElementDeclaration(true, result);
        this.assertIsWrappedElement(true, result);
    }

    @Test
    public void testAbstractWithMappingParameter() {
        ObjectType baseType = (ObjectType)this.TYPE_LOADER.load(AbstractType.class);
        Mockito.when((Object)this.typeCatalog.containsBaseType(baseType)).thenReturn((Object)true);
        Mockito.when((Object)this.typeCatalog.getSubTypes(baseType)).thenReturn(Collections.singleton((ObjectType)this.TYPE_LOADER.load(ChildOfAbstractType.class)));
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(AbstractType.class));
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertParameterChildElementDeclaration(true, result);
        this.assertIsWrappedElement(true, result);
    }

    @Test
    public void testImportedFinalTypeWithXmlParameter() {
        ExtensionModel importOriginMock = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        this.mockImportedTypes(importOriginMock, "importExtensionWithXml", SimpleFieldsType.class);
        Mockito.when((Object)importOriginMock.getXmlDslModel()).thenReturn((Object)this.createImportedXmlDslModel());
        Mockito.when((Object)this.dslContext.getExtension("importExtensionWithXml")).thenReturn(Optional.of(importOriginMock));
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(SimpleFieldsType.class));
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertElementPrefix("mockns", result);
        this.assertParameterChildElementDeclaration(true, result);
        this.assertIsWrappedElement(false, result);
    }

    @Test
    public void testImportedFinalTypeWithoutXmlParameter() {
        ExtensionModel importOriginMock = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        this.mockImportedTypes(importOriginMock, "importExtension", SimpleFieldsType.class);
        Mockito.when((Object)importOriginMock.getXmlDslModel()).thenReturn((Object)this.createImportedXmlDslModel());
        Mockito.when((Object)this.dslContext.getExtension("importExtension")).thenReturn(Optional.of(importOriginMock));
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(SimpleFieldsType.class));
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertElementPrefix("mockns", result);
        this.assertParameterChildElementDeclaration(true, result);
        this.assertIsWrappedElement(false, result);
    }

    @Test
    public void testExtensibleImportParameter() {
        ExtensionModel importOriginMock = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        this.mockImportedTypes(importOriginMock, "importExtensionWithXml", ExtensibleType.class);
        Mockito.when((Object)importOriginMock.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setXsdFileName("").setPrefix(NameUtils.defaultNamespace((String)"importExtensionWithXml")).setNamespace("http://www.mulesoft.org/schema/mule/importns").setXsdFileName("").setSchemaLocation("http://www.mulesoft.org/schema/mule/importns/current/mule-import-extension-with-xml.xsd").build());
        MetadataType paramType = this.TYPE_LOADER.load(ExtensibleType.class);
        Mockito.when((Object)this.dslContext.getExtension("importExtensionWithXml")).thenReturn(Optional.of(importOriginMock));
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)paramType);
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertElementPrefix("mockns", result);
        this.assertParameterChildElementDeclaration(true, result);
        this.assertIsWrappedElement(true, result);
        Assert.assertThat((Object)result.getAttribute("sampleString").isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)result.getAttribute("otherNumber").isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)result.getAttribute("childNumbers").isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)result.getChild("childNumbers").isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testExtensibleImportedTypeWithoutXmlParameter() {
        this.extension = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        this.mockImportedTypes(this.extension, "importExtension", ExtensibleType.class);
        Mockito.when((Object)this.extension.getXmlDslModel()).thenReturn((Object)this.createImportedXmlDslModel());
        Mockito.when((Object)this.dslContext.getExtension("importExtension")).thenReturn(Optional.of(this.extension));
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(ExtensibleType.class));
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertElementPrefix("importns", result);
        this.assertParameterChildElementDeclaration(true, result);
        this.assertIsWrappedElement(true, result);
    }

    @Test
    public void testMapOfSimpleTypeParameter() {
        DefaultStringType valueType = TYPE_BUILDER.stringType().build();
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.objectType().with((TypeAnnotation)new ClassInformationAnnotation(Map.class)).openWith((TypeBuilder)TYPE_BUILDER.stringType()).build());
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.ifContentParameter(() -> this.lambda$testMapOfSimpleTypeParameter$6(result, (MetadataType)valueType), () -> this.lambda$testMapOfSimpleTypeParameter$7(result, (MetadataType)valueType));
    }

    @Test
    public void testMapOfComplexTypeParameter() {
        MetadataType valueType = this.TYPE_LOADER.load(SimpleFieldsType.class);
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.objectType().with((TypeAnnotation)new ClassInformationAnnotation(Map.class)).openWith(this.TYPE_LOADER.load(SimpleFieldsType.class)).build());
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertElementPrefix("mockns", result);
        this.assertParameterChildElementDeclaration(true, result);
        this.assertIsWrappedElement(false, result);
        this.ifContentParameter(() -> {
            this.assertEmptyAttributeName(result);
            this.assertElementName(NameUtils.hyphenize((String)"myCamelCaseName"), result);
            this.assertNoGeneric(result, valueType);
            this.assertAttributeDeclaration(false, result);
        }, () -> {
            this.assertAttributeName("myCamelCaseName", result);
            this.assertElementName(NameUtils.hyphenize((String)NameUtils.pluralize((String)"myCamelCaseName")), result);
            this.assertElementPrefix("mockns", result);
            this.assertParameterChildElementDeclaration(true, result);
            this.assertIsWrappedElement(false, result);
            DslElementSyntax generic = this.getGenericTypeDsl(valueType, result);
            this.assertAttributeDeclaration(false, generic);
            this.assertChildElementDeclarationIs(true, generic);
            this.assertIsWrappedElement(false, generic);
            DslElementSyntax key = this.getAttributeDsl("key", generic);
            this.assertAttributeName("key", key);
            this.assertAttributeDeclaration(true, key);
            this.assertChildElementDeclarationIs(false, key);
            this.assertIsWrappedElement(false, key);
            DslElementSyntax value = this.getAttributeDsl("value", generic);
            this.assertAttributeName("value", value);
            this.assertAttributeDeclaration(true, value);
            this.assertChildElementDeclarationIs(true, value);
            this.assertIsWrappedElement(false, value);
            this.assertElementName(NameUtils.getTopLevelTypeName((MetadataType)valueType), value);
            this.getChildFieldDsl("textField", value);
        });
    }

    @Test
    public void testMapOfWrappedTypeParameter() {
        MetadataType valueType = this.TYPE_LOADER.load(ExtensibleType.class);
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.objectType().with((TypeAnnotation)new ClassInformationAnnotation(Map.class)).openWith(valueType).build());
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertElementPrefix("mockns", result);
        this.assertParameterChildElementDeclaration(true, result);
        this.assertIsWrappedElement(false, result);
        this.ifContentParameter(() -> {
            this.assertEmptyAttributeName(result);
            this.assertElementName(NameUtils.hyphenize((String)"myCamelCaseName"), result);
            this.assertNoGeneric(result, valueType);
        }, () -> {
            this.assertAttributeName("myCamelCaseName", result);
            this.assertElementName(NameUtils.hyphenize((String)NameUtils.pluralize((String)"myCamelCaseName")), result);
            this.assertElementPrefix("mockns", result);
            this.assertParameterChildElementDeclaration(true, result);
            this.assertIsWrappedElement(false, result);
            DslElementSyntax generic = this.getGenericTypeDsl(valueType, result);
            this.assertAttributeDeclaration(false, generic);
            this.assertChildElementDeclarationIs(true, generic);
            this.assertIsWrappedElement(false, generic);
            DslElementSyntax key = this.getAttributeDsl("key", generic);
            this.assertAttributeName("key", key);
            this.assertAttributeDeclaration(true, key);
            this.assertChildElementDeclarationIs(false, key);
            this.assertIsWrappedElement(false, key);
            DslElementSyntax value = this.getAttributeDsl("value", generic);
            this.assertAttributeName("value", value);
            this.assertAttributeDeclaration(true, value);
            this.assertChildElementDeclarationIs(true, value);
            this.assertIsWrappedElement(false, value);
            this.assertElementName(NameUtils.getTopLevelTypeName((MetadataType)valueType), value);
        });
    }

    @Test
    public void testMapOfNonInstantiableValueTypeParameter() {
        MetadataType valueType = this.TYPE_LOADER.load(InterfaceDeclaration.class);
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.objectType().openWith(valueType).with((TypeAnnotation)new ClassInformationAnnotation(Map.class, Arrays.asList(String.class, InterfaceDeclaration.class))).build());
        this.ifContentParameter(() -> this.assertNoGeneric(this.getSyntaxResolver().resolve(this.parameterModel), valueType), () -> {
            DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
            this.assertAttributeName("myCamelCaseName", result);
            this.assertElementName(NameUtils.hyphenize((String)NameUtils.pluralize((String)"myCamelCaseName")), result);
            this.assertElementPrefix("mockns", result);
            this.assertParameterChildElementDeclaration(true, result);
            this.assertIsWrappedElement(false, result);
            DslElementSyntax innerElement = this.getGenericTypeDsl(valueType, result);
            this.assertElementName(NameUtils.hyphenize((String)NameUtils.singularize((String)"myCamelCaseName")), innerElement);
            this.assertIsWrappedElement(false, innerElement);
        });
    }

    @Test
    public void testMapOfNonInstantiableValueTypeWithMappedSubtypesParameter() {
        ObjectType valueType = (ObjectType)this.TYPE_LOADER.load(InterfaceDeclarationWithMapping.class);
        Mockito.when((Object)this.typeCatalog.containsBaseType(valueType)).thenReturn((Object)true);
        Mockito.when((Object)this.typeCatalog.getSubTypes(valueType)).thenReturn(Collections.singleton((ObjectType)this.TYPE_LOADER.load(InterfaceImplementation.class)));
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.objectType().with((TypeAnnotation)new ClassInformationAnnotation(Map.class)).openWith((MetadataType)valueType).build());
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertElementPrefix("mockns", result);
        this.assertParameterChildElementDeclaration(true, result);
        this.assertIsWrappedElement(false, result);
        this.ifContentParameter(() -> {
            this.assertEmptyAttributeName(result);
            this.assertElementName(NameUtils.hyphenize((String)"myCamelCaseName"), result);
            this.assertNoGeneric(result, (MetadataType)valueType);
        }, () -> {
            this.assertAttributeName("myCamelCaseName", result);
            this.assertElementName(NameUtils.hyphenize((String)NameUtils.pluralize((String)"myCamelCaseName")), result);
            this.assertElementPrefix("mockns", result);
            this.assertParameterChildElementDeclaration(true, result);
            this.assertIsWrappedElement(false, result);
            DslElementSyntax generic = this.getGenericTypeDsl((MetadataType)valueType, result);
            this.assertAttributeDeclaration(false, generic);
            this.assertChildElementDeclarationIs(true, generic);
            this.assertIsWrappedElement(false, generic);
            DslElementSyntax key = this.getAttributeDsl("key", generic);
            this.assertAttributeName("key", key);
            this.assertAttributeDeclaration(true, key);
            this.assertChildElementDeclarationIs(false, key);
            this.assertIsWrappedElement(false, key);
            DslElementSyntax value = this.getAttributeDsl("value", generic);
            this.assertAttributeName("value", value);
            this.assertAttributeDeclaration(true, value);
            this.assertChildElementDeclarationIs(false, value);
            this.assertIsWrappedElement(true, value);
            this.assertElementName("", value);
        });
    }

    @Test
    public void testCollectionOfSimpleTypeParameter() {
        DefaultStringType itemType = TYPE_BUILDER.stringType().build();
        Mockito.when((Object)this.parameterModel.getName()).thenReturn((Object)"singularizableNames");
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.arrayType().of((MetadataType)itemType).build());
        this.ifContentParameter(() -> this.lambda$testCollectionOfSimpleTypeParameter$16((MetadataType)itemType), () -> this.lambda$testCollectionOfSimpleTypeParameter$17((MetadataType)itemType));
    }

    @Test
    public void testCollectionWithSameSingularizedChildName() {
        DefaultStringType itemType = TYPE_BUILDER.stringType().build();
        Mockito.when((Object)this.parameterModel.getName()).thenReturn((Object)"myCamelCaseName");
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.arrayType().of((MetadataType)itemType).build());
        this.ifContentParameter(() -> this.lambda$testCollectionWithSameSingularizedChildName$18((MetadataType)itemType), () -> this.lambda$testCollectionWithSameSingularizedChildName$19((MetadataType)itemType));
    }

    private void assertCollectionDslElementSyntax(MetadataType itemType, ParameterModel parameterModel, String parameterName, String elementName, String childElementName) {
        DslElementSyntax result = this.getSyntaxResolver().resolve(parameterModel);
        this.assertAttributeName(parameterName, result);
        this.assertElementName(elementName, result);
        this.assertElementPrefix("mockns", result);
        this.assertParameterChildElementDeclaration(true, result);
        this.assertIsWrappedElement(false, result);
        DslElementSyntax innerElement = this.getGenericTypeDsl(itemType, result);
        this.assertElementName(childElementName, innerElement);
        this.assertParameterChildElementDeclaration(true, innerElement);
        this.assertIsWrappedElement(false, innerElement);
    }

    @Test
    public void testCollectionOfComplexTypeParameter() {
        MetadataType itemType = this.TYPE_LOADER.load(SimpleFieldsType.class);
        Mockito.when((Object)this.parameterModel.getName()).thenReturn((Object)"myCamelCaseNames");
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.arrayType().of(itemType).build());
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertParameterChildElementDeclaration(true, result);
        this.assertIsWrappedElement(false, result);
        this.ifContentParameter(() -> {
            this.assertEmptyAttributeName(result);
            this.assertNoGeneric(result, itemType);
        }, () -> {
            this.assertAttributeName("myCamelCaseNames", result);
            this.assertElementName(NameUtils.hyphenize((String)"myCamelCaseNames"), result);
            this.assertElementPrefix("mockns", result);
            DslElementSyntax innerElement = this.getGenericTypeDsl(itemType, result);
            this.assertElementName(NameUtils.getTopLevelTypeName((MetadataType)itemType), innerElement);
            this.assertElementPrefix("mockns", innerElement);
            this.assertParameterChildElementDeclaration(true, innerElement);
        });
    }

    private void ifNotContentParameter(Runnable test) {
        this.ifContentParameter(() -> {}, test);
    }

    private void assertNoGeneric(DslElementSyntax syntax, MetadataType genericType) {
        Assert.assertThat((Object)syntax.getGeneric(genericType).isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testCollectionOfWrappedTypeParameter() {
        MetadataType itemType = this.TYPE_LOADER.load(ExtensibleType.class);
        Mockito.when((Object)this.parameterModel.getName()).thenReturn((Object)"myCamelCaseNames");
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.arrayType().of(itemType).build());
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertParameterChildElementDeclaration(true, result);
        this.assertIsWrappedElement(false, result);
        this.ifContentParameter(() -> this.assertNoGeneric(result, itemType), () -> {
            this.assertElementPrefix("mockns", result);
            this.assertAttributeName("myCamelCaseNames", result);
            this.assertElementName(NameUtils.hyphenize((String)"myCamelCaseNames"), result);
            DslElementSyntax listItemDsl = this.getGenericTypeDsl(itemType, result);
            this.assertElementName(NameUtils.getTopLevelTypeName((MetadataType)itemType), listItemDsl);
            this.assertElementPrefix("mockns", listItemDsl);
            this.assertParameterChildElementDeclaration(true, listItemDsl);
            this.assertTopElementDeclarationIs(false, listItemDsl);
            this.assertIsWrappedElement(true, listItemDsl);
        });
    }

    @Test
    public void testCollectionOfNonInstantiableTypeParameter() {
        MetadataType itemType = this.TYPE_LOADER.load(InterfaceDeclaration.class);
        Mockito.when((Object)this.parameterModel.getName()).thenReturn((Object)"myCamelCaseNames");
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.arrayType().of(itemType).build());
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.ifNotContentParameter(() -> {
            this.assertAttributeName("myCamelCaseNames", result);
            this.assertElementName(NameUtils.hyphenize((String)"myCamelCaseNames"), result);
            this.assertElementPrefix("mockns", result);
        });
        this.assertParameterChildElementDeclaration(false, result);
        this.assertIsWrappedElement(false, result);
        Assert.assertThat((Object)result.getGeneric(itemType).isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testMapOfListOfComplexTypeParameter() {
        MetadataType itemType = this.TYPE_LOADER.load(ExtensibleType.class);
        ArrayType valueType = TYPE_BUILDER.arrayType().of(itemType).build();
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.objectType().with((TypeAnnotation)new ClassInformationAnnotation(Map.class)).openWith((MetadataType)valueType).build());
        DslElementSyntax mapDsl = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertElementPrefix("mockns", mapDsl);
        this.assertParameterChildElementDeclaration(true, mapDsl);
        this.assertIsWrappedElement(false, mapDsl);
        this.ifContentParameter(() -> this.lambda$testMapOfListOfComplexTypeParameter$26(mapDsl, (MetadataType)valueType), () -> this.lambda$testMapOfListOfComplexTypeParameter$27(mapDsl, (MetadataType)valueType, itemType));
    }

    @Test
    public void testMapOfListOfSimpleTypeParameter() {
        MetadataType itemType = this.TYPE_LOADER.load(String.class);
        ArrayType valueType = TYPE_BUILDER.arrayType().of(itemType).build();
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.objectType().openWith((MetadataType)valueType).with((TypeAnnotation)new ClassInformationAnnotation(Map.class)).build());
        DslElementSyntax mapDsl = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertElementPrefix("mockns", mapDsl);
        this.assertParameterChildElementDeclaration(true, mapDsl);
        this.assertIsWrappedElement(false, mapDsl);
        this.ifContentParameter(() -> this.lambda$testMapOfListOfSimpleTypeParameter$28(mapDsl, (MetadataType)valueType), () -> this.lambda$testMapOfListOfSimpleTypeParameter$29(mapDsl, (MetadataType)valueType, itemType));
    }

    @Test
    public void testListOfMapsParameter() {
        ObjectType dictionary = TYPE_BUILDER.objectType().with((TypeAnnotation)new ClassInformationAnnotation(Map.class)).openWith((TypeBuilder)TYPE_BUILDER.stringType()).build();
        Mockito.when((Object)this.parameterModel.getName()).thenReturn((Object)"myCamelCaseNames");
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.arrayType().of((MetadataType)dictionary).build());
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.ifNotContentParameter(() -> {
            this.assertAttributeName("myCamelCaseNames", result);
            this.assertElementName(NameUtils.hyphenize((String)"myCamelCaseNames"), result);
            this.assertElementPrefix("mockns", result);
        });
        this.assertParameterChildElementDeclaration(false, result);
        this.assertIsWrappedElement(false, result);
    }

    private /* synthetic */ void lambda$testMapOfListOfSimpleTypeParameter$29(DslElementSyntax mapDsl, MetadataType valueType, MetadataType itemType) {
        this.assertAttributeName("myCamelCaseName", mapDsl);
        this.assertElementName(NameUtils.hyphenize((String)NameUtils.pluralize((String)"myCamelCaseName")), mapDsl);
        DslElementSyntax listDsl = this.getGenericTypeDsl(valueType, mapDsl);
        this.assertElementName(NameUtils.hyphenize((String)NameUtils.singularize((String)"myCamelCaseName")), listDsl);
        this.assertParameterChildElementDeclaration(true, listDsl);
        this.assertIsWrappedElement(false, listDsl);
        DslElementSyntax itemDsl = this.getGenericTypeDsl(itemType, listDsl);
        this.assertElementName(NameUtils.itemize((String)"myCamelCaseName"), itemDsl);
        this.assertParameterChildElementDeclaration(true, itemDsl);
        this.assertIsWrappedElement(false, itemDsl);
    }

    private /* synthetic */ void lambda$testMapOfListOfSimpleTypeParameter$28(DslElementSyntax mapDsl, MetadataType valueType) {
        this.assertEmptyAttributeName(mapDsl);
        this.assertElementName(NameUtils.hyphenize((String)"myCamelCaseName"), mapDsl);
        this.assertNoGeneric(mapDsl, valueType);
    }

    private /* synthetic */ void lambda$testMapOfListOfComplexTypeParameter$27(DslElementSyntax mapDsl, MetadataType valueType, MetadataType itemType) {
        this.assertAttributeName("myCamelCaseName", mapDsl);
        this.assertElementName(NameUtils.hyphenize((String)NameUtils.pluralize((String)"myCamelCaseName")), mapDsl);
        DslElementSyntax listDsl = this.getGenericTypeDsl(valueType, mapDsl);
        this.assertElementName(NameUtils.hyphenize((String)NameUtils.singularize((String)"myCamelCaseName")), listDsl);
        this.assertParameterChildElementDeclaration(true, listDsl);
        this.assertIsWrappedElement(false, listDsl);
        DslElementSyntax listItemDsl = this.getGenericTypeDsl(itemType, listDsl);
        this.assertElementName(NameUtils.getTopLevelTypeName((MetadataType)itemType), listItemDsl);
        this.assertElementPrefix("mockns", listItemDsl);
        this.assertParameterChildElementDeclaration(true, listItemDsl);
        this.assertTopElementDeclarationIs(false, listItemDsl);
        this.assertIsWrappedElement(true, listItemDsl);
    }

    private /* synthetic */ void lambda$testMapOfListOfComplexTypeParameter$26(DslElementSyntax mapDsl, MetadataType valueType) {
        this.assertEmptyAttributeName(mapDsl);
        this.assertElementName(NameUtils.hyphenize((String)"myCamelCaseName"), mapDsl);
        this.assertNoGeneric(mapDsl, valueType);
    }

    private /* synthetic */ void lambda$testCollectionWithSameSingularizedChildName$19(MetadataType itemType) {
        this.assertCollectionDslElementSyntax(itemType, this.parameterModel, "myCamelCaseName", NameUtils.hyphenize((String)"myCamelCaseName"), NameUtils.itemize((String)"myCamelCaseName"));
    }

    private /* synthetic */ void lambda$testCollectionWithSameSingularizedChildName$18(MetadataType itemType) {
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertNoGeneric(result, itemType);
    }

    private /* synthetic */ void lambda$testCollectionOfSimpleTypeParameter$17(MetadataType itemType) {
        this.assertCollectionDslElementSyntax(itemType, this.parameterModel, "singularizableNames", NameUtils.hyphenize((String)"singularizableNames"), NameUtils.hyphenize((String)NameUtils.singularize((String)"singularizableNames")));
    }

    private /* synthetic */ void lambda$testCollectionOfSimpleTypeParameter$16(MetadataType itemType) {
        this.assertNoGeneric(this.getSyntaxResolver().resolve(this.parameterModel), itemType);
    }

    private /* synthetic */ void lambda$testMapOfSimpleTypeParameter$7(DslElementSyntax result, MetadataType valueType) {
        this.assertAttributeName("myCamelCaseName", result);
        this.assertElementName(NameUtils.hyphenize((String)NameUtils.pluralize((String)"myCamelCaseName")), result);
        this.assertElementPrefix("mockns", result);
        this.assertParameterChildElementDeclaration(true, result);
        this.assertIsWrappedElement(false, result);
        DslElementSyntax generic = this.getGenericTypeDsl(valueType, result);
        this.assertAttributeDeclaration(false, generic);
        this.assertChildElementDeclarationIs(true, generic);
        this.assertIsWrappedElement(false, generic);
        DslElementSyntax key = this.getAttributeDsl("key", generic);
        this.assertAttributeName("key", key);
        this.assertAttributeDeclaration(true, key);
        this.assertChildElementDeclarationIs(false, key);
        this.assertIsWrappedElement(false, key);
        DslElementSyntax value = this.getAttributeDsl("value", generic);
        this.assertAttributeName("value", value);
        this.assertAttributeDeclaration(true, value);
        this.assertChildElementDeclarationIs(false, value);
        this.assertIsWrappedElement(false, value);
    }

    private /* synthetic */ void lambda$testMapOfSimpleTypeParameter$6(DslElementSyntax result, MetadataType valueType) {
        this.assertNoAttributes(result);
        this.assertNoGeneric(result, valueType);
    }
}

