/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.runtime.operation;

import java.util.Optional;
import java.util.OptionalLong;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.MediaType;

public class Result<T, A> {
    private T output;
    private A attributes = null;
    private MediaType mediaType = null;
    private MediaType attributesMediaType = null;
    private OptionalLong length = OptionalLong.empty();

    public static <T, A> Builder<T, A> builder() {
        return new Builder();
    }

    public static <T, A> Builder<T, A> builder(Message muleMessage) {
        return new Builder().output(muleMessage.getPayload().getValue()).attributes(muleMessage.getAttributes().getValue()).mediaType(muleMessage.getPayload().getDataType().getMediaType()).attributesMediaType(muleMessage.getAttributes().getDataType().getMediaType());
    }

    protected Result() {
    }

    public Builder<T, A> copy() {
        Builder builder = new Builder().output(this.output);
        this.getAttributes().ifPresent(builder::attributes);
        this.getMediaType().ifPresent(builder::mediaType);
        this.getAttributesMediaType().ifPresent(builder::attributesMediaType);
        return builder;
    }

    public T getOutput() {
        return this.output;
    }

    public Optional<A> getAttributes() {
        return Optional.ofNullable(this.attributes);
    }

    public Optional<MediaType> getMediaType() {
        return Optional.ofNullable(this.mediaType);
    }

    @Deprecated
    public Optional<Long> getLength() {
        if (this.length.isPresent()) {
            return Optional.of(this.length.getAsLong());
        }
        return Optional.empty();
    }

    public OptionalLong getByteLength() {
        return this.length;
    }

    public Optional<MediaType> getAttributesMediaType() {
        return Optional.ofNullable(this.attributesMediaType);
    }

    public static class Builder<T, A> {
        private final Result<T, A> product = new Result();

        protected Builder() {
        }

        public Builder<T, A> output(T output) {
            ((Result)this.product).output = output;
            return this;
        }

        public Builder<T, A> attributes(A attributes) {
            ((Result)this.product).attributes = attributes;
            return this;
        }

        public Builder<T, A> mediaType(MediaType mediaType) {
            ((Result)this.product).mediaType = mediaType;
            return this;
        }

        public Builder<T, A> attributesMediaType(MediaType mediaType) {
            ((Result)this.product).attributesMediaType = mediaType;
            return this;
        }

        @Deprecated
        public Builder<T, A> length(Long length) {
            if (length != null) {
                ((Result)this.product).length = OptionalLong.of(length);
            } else {
                ((Result)this.product).length = OptionalLong.empty();
            }
            return this;
        }

        public Builder<T, A> length(long length) {
            ((Result)this.product).length = OptionalLong.of(length);
            return this;
        }

        public Result<T, A> build() {
            return this.product;
        }
    }
}

