/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.util;

import java.util.Comparator;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;

public class ParameterModelComparator
implements Comparator<ParameterModel> {
    private final boolean infrastructureFirst;

    public ParameterModelComparator(boolean infrastructureFirst) {
        this.infrastructureFirst = infrastructureFirst;
    }

    @Override
    public int compare(ParameterModel left, ParameterModel right) {
        boolean isLeftInfrastructure = ExtensionModelUtils.isInfrastructure(left);
        boolean isRightInfrastructure = ExtensionModelUtils.isInfrastructure(right);
        if (!isLeftInfrastructure && !isRightInfrastructure) {
            return 0;
        }
        if (isLeftInfrastructure) {
            return this.infrastructureFirst ? -1 : 1;
        }
        if (isRightInfrastructure) {
            return this.infrastructureFirst ? 1 : -1;
        }
        return left.getName().compareTo(right.getName());
    }
}

