/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.annotation;

import org.mule.metadata.api.utils.MetadataTypeUtils;

import java.util.Objects;

/**
 * Used to specify a type alias for this type.
 */
public class TypeAliasAnnotation implements TypeAnnotation {

  public static final String NAME = "typeAlias";
  private final String value;

  public TypeAliasAnnotation(String value) {
    MetadataTypeUtils.checkArgument(value != null, "Illegal empty value for type alias annotation.");
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String getName() {
    return NAME;
  }

  @Override
  public boolean equals(Object obj) {
    if (obj instanceof TypeAliasAnnotation) {
      return Objects.equals(value, ((TypeAliasAnnotation) obj).getValue());
    }

    return false;
  }

  @Override
  public int hashCode() {
    return value.hashCode();
  }

  @Override
  public String toString() {
    return value;
  }
}
