/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model;

import org.mule.api.annotation.NoImplement;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

import java.util.Optional;
import java.util.Set;

/**
 * Base interface for all the Types
 */
@NoImplement
public interface MetadataType {

  /**
   * Return the format of the underlying type system where this type was
   * mapped from. I.E XML
   *
   * @return The format.
   */
  MetadataFormat getMetadataFormat();

  /**
   * Returns an {@link Optional} with the annotation of a given type.
   *
   * @param annotation The type of annotation
   * @return {@link Optional} with the matched annotation. {@link Optional#empty()} if the annotation was not present.
   */
  <T extends TypeAnnotation> Optional<T> getAnnotation(Class<T> annotation);

  /**
   * Returns all the annotations of the type.
   *
   * @return The collection of annotations
   */
  Set<TypeAnnotation> getAnnotations();

  /**
   * Returns the description if specified.
   *
   * @return The description if any.
   */
  Optional<String> getDescription();

  /**
   * Dispatches in a reflective way to the method with prefix "visit" with the specific type as argument.
   * Example {@code visitObject(ObjectType objectType) } will be called when this type is an ObjectType.
   * @param visitor The visitor
   */
  void accept(MetadataTypeVisitor visitor);
}
