/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model.impl;


import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.FunctionParameter;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DefaultFunctionType extends BaseMetadataType implements FunctionType {

  private final Optional<MetadataType> returnType;
  private final List<FunctionParameter> parameters;

  public DefaultFunctionType(MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> annotations,
                             Optional<MetadataType> returnType, List<FunctionParameter> parameters) {
    super(metadataFormat, annotations);
    this.returnType = returnType;
    this.parameters = parameters;
  }

  @Override
  public List<FunctionParameter> getParameters() {
    return parameters;
  }

  @Override
  public Optional<MetadataType> getReturnType() {
    return returnType;
  }

  @Override
  public void accept(MetadataTypeVisitor visitor) {
    visitor.visitFunction(this);
  }
}
