/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model.impl;

import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

import java.util.Map;

public class DefaultObjectFieldType extends BaseMetadataType implements ObjectFieldType {

  private ObjectKeyType key;
  private MetadataType value;
  private boolean isRequired;
  private boolean isRepeated;

  public DefaultObjectFieldType(ObjectKeyType key, MetadataType value, boolean isRequired, boolean isRepeated,
                                MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> annotations) {
    super(metadataFormat, annotations);
    this.key = key;
    this.value = value;
    this.isRequired = isRequired;
    this.isRepeated = isRepeated;
  }

  @Override
  public ObjectKeyType getKey() {
    return key;
  }

  @Override
  public MetadataType getValue() {
    return value;
  }

  @Override
  public boolean isRequired() {
    return isRequired;
  }

  public boolean isRepeated() {
    return isRepeated;
  }

  @Override
  public void accept(MetadataTypeVisitor visitor) {
    visitor.visitObjectField(this);
  }
}
