/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model.impl;


import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.TypeParameterType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

import java.util.Map;

public class DefaultTypeParameterType extends BaseMetadataType implements TypeParameterType {

  private String name;

  public DefaultTypeParameterType(String name, MetadataFormat metadataFormat,
                                  Map<Class<? extends TypeAnnotation>, TypeAnnotation> annotations) {
    super(metadataFormat, annotations);
    this.name = name;
  }

  @Override
  public String getName() {
    return name;
  }

  @Override
  public void accept(MetadataTypeVisitor visitor) {
    visitor.visitTypeParameter(this);
  }
}
