/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.java.internal.handler;

import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.java.api.handler.TypeHandlerManager;
import org.mule.metadata.java.api.utils.ParsingContext;
import org.mule.metadata.java.api.utils.TypeResolver;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class CollectionClassHandler extends BaseClassHandler {

  public CollectionClassHandler() {
    super(Iterable.class, Iterator.class);
  }

  @Override
  public TypeBuilder<?> handleClass(Class<?> clazz,
                                    List<Type> genericTypes, TypeHandlerManager typeHandlerManager,
                                    ParsingContext context, BaseTypeBuilder typeBuilder) {
    final Optional<Type> type = getGenericType(clazz, genericTypes);
    final ArrayTypeBuilder arrayType = typeBuilder.arrayType().with(new ClassInformationAnnotation(clazz));
    context.addTypeBuilder(clazz, arrayType);

    if (type.isPresent()) {
      final Type arrayGenericType = type.get();
      final Optional<TypeBuilder<?>> mayBeBuilder = context.getTypeBuilder(arrayGenericType);
      if (mayBeBuilder.isPresent()) {
        arrayType.of(mayBeBuilder.get());
      } else {
        typeHandlerManager.handle(arrayGenericType, context, arrayType.of());
      }
    } else {
      arrayType.of().anyType();
    }
    return arrayType;
  }

  public Optional<Type> getGenericType(Class<?> clazz, List<Type> genericTypes) {
    final ParameterizedType parametrizedType = TypeResolver.getGenericSuperclass(clazz, Iterable.class);
    if (genericTypes.isEmpty()) {
      if (parametrizedType != null) {
        return Optional.of(parametrizedType.getActualTypeArguments()[0]);
      } else {
        return Optional.empty();
      }
    } else {
      return Optional.of(genericTypes.get(0));
    }
  }
}
