/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.java;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Before;
import org.junit.Test;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.java.AbstractClassHandlerTestCase;
import org.mule.metadata.java.api.handler.DefaultObjectFieldHandler;
import org.mule.metadata.java.api.handler.TypeHandlerManager;
import org.mule.metadata.java.api.utils.ParsingContext;
import org.mule.metadata.java.internal.handler.MapClassHandler;

public class MapClassHandlerTestCase
extends AbstractClassHandlerTestCase {
    private MapClassHandler handler;

    @Before
    public void setup() {
        this.handler = new MapClassHandler();
        this.objectFieldHandler = new DefaultObjectFieldHandler();
        this.typeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
    }

    @Test
    public void testInheritedGenericsFromInterface() {
        this.assertMapTypes(MyMap.class, WithCustomMap.class, StringType.class);
    }

    @Test
    public void testRawMap() {
        this.assertMapTypes(Map.class, WithRawMap.class, AnyType.class);
    }

    @Test
    public void testInheritedGenericsFromClass() {
        this.assertMapTypes(MyExtraCustomMap.class, WithExtraCustomMap.class, StringType.class);
    }

    private void assertMapTypes(Class<? extends Map> mapType, Class containerType, Class valueType) {
        MatcherAssert.assertThat((Object)this.handler.handles(mapType), (Matcher)Is.is((Object)true));
        this.objectFieldHandler.handleFields(containerType, TypeHandlerManager.createDefault(), new ParsingContext(), this.typeBuilder);
        List<ObjectFieldType> fields = this.getFields(this.typeBuilder);
        MatcherAssert.assertThat((Object)fields.isEmpty(), (Matcher)Is.is((Object)false));
        ObjectType field = (ObjectType)fields.get(0).getValue();
        MatcherAssert.assertThat((Object)field.isOpen(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat(field.getOpenRestriction().get(), (Matcher)IsInstanceOf.instanceOf((Class)valueType));
    }

    private class WithExtraCustomMap {
        MyExtraCustomMap customMap;

        private WithExtraCustomMap() {
        }

        public MyMap getCustomMap() {
            return this.customMap;
        }

        public void setCustomMap(MyExtraCustomMap customMap) {
            this.customMap = customMap;
        }
    }

    private class WithCustomMap {
        MyMap customMap;

        private WithCustomMap() {
        }

        public MyMap getCustomMap() {
            return this.customMap;
        }

        public void setCustomMap(MyMap customMap) {
            this.customMap = customMap;
        }
    }

    private class WithRawMap {
        Map simpleMap;

        private WithRawMap() {
        }

        public Map getSimpleMap() {
            return this.simpleMap;
        }
    }

    private static interface MyMapInterface
    extends Map<String, String> {
    }

    private class MyMap
    implements MyMapInterface {
        private MyMap() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public String get(Object key) {
            return null;
        }

        @Override
        public String put(String key, String value) {
            return null;
        }

        @Override
        public String remove(Object key) {
            return null;
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> m) {
        }

        @Override
        public void clear() {
        }

        @Override
        public Set<String> keySet() {
            return null;
        }

        @Override
        public Collection<String> values() {
            return null;
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return null;
        }
    }

    private class MyExtraCustomMap
    extends MyMap {
        private MyExtraCustomMap() {
        }
    }
}

