/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.xml.api.schema;

import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SchemaFetcher {
    private static Map<String, ContentFetcher> contentFetchers = new HashMap<String, ContentFetcher>();

    public List<XsdDependency> fetchAll(URL ... urls) {
        return new SchemaFetcherRequest().fetchAll(urls);
    }

    static {
        contentFetchers.put("http", new HTTPContentFetcher());
        contentFetchers.put("file", new FileContentFetcher());
    }

    private static class NoOpEntityResolver
    implements EntityResolver {
        private NoOpEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(new StringReader(""));
        }
    }

    private static class HTTPContentFetcher
    implements ContentFetcher {
        private static final String DELIMITER = "\\A";

        private HTTPContentFetcher() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Optional<String> fetchContent(URL url) {
            try (Scanner scanner = new Scanner(url.openStream(), StandardCharsets.UTF_8.name());){
                Optional<String> optional = Optional.of(scanner.useDelimiter(DELIMITER).next());
                return optional;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class FileContentFetcher
    implements ContentFetcher {
        private static final String DELIMITER = "\\Z";

        private FileContentFetcher() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Optional<String> fetchContent(URL url) {
            try (Scanner scanner = new Scanner(url.openStream(), StandardCharsets.UTF_8.name());){
                Optional<String> optional = Optional.of(scanner.useDelimiter(DELIMITER).next());
                return optional;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static interface ContentFetcher {
        public Optional<String> fetchContent(URL var1);
    }

    private static class SchemaFetcherRequest {
        private Map<String, Schema> schemas = new HashMap<String, Schema>();

        private SchemaFetcherRequest() {
        }

        public List<XsdDependency> fetchAll(URL ... urls) {
            ArrayList<XsdDependency> dependencies = new ArrayList<XsdDependency>();
            for (URL url : urls) {
                Schema schema = new Schema(url);
                dependencies.addAll(schema.fetchDependencies());
            }
            return dependencies;
        }

        private class Schema {
            private static final String FILE = "file";
            private static final String HTTP = "http";
            private static final String CURRENT_DIRECTORY = ".";
            private static final String BACKWARD_DIRECTORY = "..";
            private static final String SCHEMA_LOCATION = "schemaLocation";
            private URL url;
            private Map<String, Schema> includesAndImports = new HashMap<String, Schema>();

            public Schema(URL url) {
                this.url = url;
            }

            public URL getUrl() {
                return this.url;
            }

            public List<XsdDependency> fetchDependencies() {
                Optional maybeContent;
                ArrayList<XsdDependency> dependencies = new ArrayList<XsdDependency>();
                ContentFetcher contentFetcher = (ContentFetcher)contentFetchers.get(this.url.getProtocol());
                Optional<Object> optional = maybeContent = contentFetcher != null ? contentFetcher.fetchContent(this.url) : Optional.empty();
                if (maybeContent.isPresent()) {
                    InputSource source = new InputSource(new StringReader((String)maybeContent.get()));
                    List<Node> includesAndImportsNodes = this.getXpathNodes(source, "/*[local-name()='schema']/*[local-name()='include' or local-name()='import']");
                    for (Node element : includesAndImportsNodes) {
                        String schemaLocation;
                        Optional<URL> maybeUrl;
                        Node schemaLocationAttribute = element.getAttributes().getNamedItem(SCHEMA_LOCATION);
                        if (schemaLocationAttribute == null || !(maybeUrl = this.buildUrl(this.url, schemaLocation = schemaLocationAttribute.getNodeValue())).isPresent()) continue;
                        URL dependency = maybeUrl.get();
                        Schema schema = new Schema(dependency);
                        this.includesAndImports.put(schemaLocation, schema);
                        dependencies.add(new XsdDependency(this.url, dependency));
                    }
                    SchemaFetcherRequest.this.schemas.put(this.url.toString(), this);
                    for (Schema schemaToIncludeOrImport : this.includesAndImports.values()) {
                        if (SchemaFetcherRequest.this.schemas.containsKey(schemaToIncludeOrImport.getUrl().toString())) continue;
                        dependencies.addAll(schemaToIncludeOrImport.fetchDependencies());
                    }
                }
                return dependencies;
            }

            private List<Node> getXpathNodes(InputSource source, String path) {
                try {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    builder.setEntityResolver(new NoOpEntityResolver());
                    Document doc = builder.parse(source);
                    XPathFactory xPathfactory = XPathFactory.newInstance();
                    XPath xpath = xPathfactory.newXPath();
                    XPathExpression expr = xpath.compile(path);
                    NodeList nodeList = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
                    int size = nodeList.getLength();
                    ArrayList<Node> nodes = new ArrayList<Node>(size);
                    for (int i = 0; i < size; ++i) {
                        nodes.add(nodeList.item(i));
                    }
                    return nodes;
                }
                catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
                    throw new RuntimeException(e);
                }
            }

            private Optional<URL> buildUrl(URL parent, String schemaLocation) {
                try {
                    if (schemaLocation.startsWith(HTTP) || schemaLocation.startsWith(FILE)) {
                        return Optional.of(new URL(schemaLocation));
                    }
                    URI parentUri = parent.toURI().getPath().endsWith("/") ? parent.toURI().resolve(BACKWARD_DIRECTORY) : parent.toURI().resolve(CURRENT_DIRECTORY);
                    URL url = new URL(parentUri.toURL().toString() + schemaLocation);
                    return Optional.of(new URL(url.toURI().normalize().toString()));
                }
                catch (MalformedURLException | URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static class XsdDependency {
        private URL parent;
        private URL dependency;

        public XsdDependency(URL parent, URL dependency) {
            this.parent = parent;
            this.dependency = dependency;
        }

        public URL getParent() {
            return this.parent;
        }

        public URL getDependency() {
            return this.dependency;
        }
    }
}

