/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.classloader;

import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.DirectoryResourceLocator;
import org.mule.runtime.module.artifact.api.classloader.FineGrainedControlClassLoader;
import org.mule.runtime.module.artifact.api.classloader.LocalResourceLocator;
import org.mule.runtime.module.artifact.api.classloader.ResourceReleaser;
import org.mule.runtime.module.artifact.api.classloader.ShutdownListener;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleArtifactClassLoader
extends FineGrainedControlClassLoader
implements ArtifactClassLoader {
    private static final Logger LOGGER;
    private static final String DEFAULT_RESOURCE_RELEASER_CLASS_LOCATION = "/org/mule/module/artifact/classloader/DefaultResourceReleaser.class";
    protected List<ShutdownListener> shutdownListeners = new ArrayList<ShutdownListener>();
    private final String artifactId;
    private LocalResourceLocator localResourceLocator;
    private String resourceReleaserClassLocation = "/org/mule/module/artifact/classloader/DefaultResourceReleaser.class";
    private ArtifactDescriptor artifactDescriptor;

    public MuleArtifactClassLoader(String artifactId, ArtifactDescriptor artifactDescriptor, URL[] urls, ClassLoader parent, ClassLoaderLookupPolicy lookupPolicy) {
        super(urls, parent, lookupPolicy);
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)artifactId) ? 1 : 0) != 0, (String)"artifactId cannot be empty");
        Preconditions.checkArgument((artifactDescriptor != null ? 1 : 0) != 0, (String)"artifactDescriptor cannot be null");
        this.artifactId = artifactId;
        this.artifactDescriptor = artifactDescriptor;
        this.configureErrorHooks();
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public <T extends ArtifactDescriptor> T getArtifactDescriptor() {
        return (T)this.artifactDescriptor;
    }

    protected String[] getLocalResourceLocations() {
        return new String[0];
    }

    @Override
    public ClassLoader getClassLoader() {
        return this;
    }

    @Override
    public void addShutdownListener(ShutdownListener listener) {
        this.shutdownListeners.add(listener);
    }

    @Override
    public void dispose() {
        try {
            this.createResourceReleaserInstance().release();
        }
        catch (Exception e) {
            LOGGER.error("Cannot create resource releaser instance", (Throwable)e);
        }
        super.dispose();
        this.shutdownListeners();
    }

    private void shutdownListeners() {
        for (ShutdownListener listener : this.shutdownListeners) {
            try {
                listener.execute();
            }
            catch (Exception e) {
                LOGGER.error("Error executing shutdown listener", (Throwable)e);
            }
        }
        this.shutdownListeners.clear();
    }

    private <T> T createCustomInstance(String classLocation) {
        Object obj;
        InputStream classStream = null;
        try {
            classStream = this.getClass().getResourceAsStream(classLocation);
            byte[] classBytes = IOUtils.toByteArray((InputStream)classStream);
            classStream.close();
            Class<?> clazz = this.defineClass(null, classBytes, 0, classBytes.length);
            obj = clazz.newInstance();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Can not create instance from resource: " + classLocation, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(classStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)classStream);
        return (T)obj;
    }

    protected ResourceReleaser createResourceReleaserInstance() {
        return (ResourceReleaser)this.createCustomInstance(this.resourceReleaserClassLocation);
    }

    public void setResourceReleaserClassLocation(String resourceReleaserClassLocation) {
        this.resourceReleaserClassLocation = resourceReleaserClassLocation;
    }

    private static String getErrorHooksClassLocation() {
        return "/org/mule/module/artifact/classloader/ErrorHooksConfiguration.class";
    }

    private void configureErrorHooks() {
        if (this.getURLs().length == 0 || !MuleArtifactClassLoader.isReactorLoaded(this).booleanValue()) {
            return;
        }
        try {
            this.createCustomInstance(MuleArtifactClassLoader.getErrorHooksClassLocation());
        }
        catch (Exception e) {
            LOGGER.error("Cannot configure error hooks", (Throwable)e);
        }
    }

    private static Boolean isReactorLoaded(MuleArtifactClassLoader cl) {
        try {
            Class<?> reactorHooks = cl.loadClass("reactor.core.publisher.Hooks");
            return reactorHooks.getClassLoader().equals(cl);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @Override
    public URL findLocalResource(String resourceName) {
        return this.getLocalResourceLocator().findLocalResource(resourceName);
    }

    private LocalResourceLocator getLocalResourceLocator() {
        if (this.localResourceLocator == null) {
            this.localResourceLocator = new DirectoryResourceLocator(this.getLocalResourceLocations());
        }
        return this.localResourceLocator;
    }

    public String toString() {
        return String.format("%s[%s]@%s", this.getClass().getName(), this.getArtifactId(), Integer.toHexString(System.identityHashCode(this)));
    }

    static {
        MuleArtifactClassLoader.registerAsParallelCapable();
        LOGGER = LoggerFactory.getLogger(MuleArtifactClassLoader.class);
    }
}

