/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.container.internal.JreExplorer;
import org.mule.runtime.container.internal.ModuleDiscoverer;
import org.mule.runtime.module.artifact.classloader.ExportedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JreModuleDiscoverer
implements ModuleDiscoverer {
    protected static final Logger logger = LoggerFactory.getLogger(JreModuleDiscoverer.class);
    protected static final String JRE_MODULE_NAME = "jre";

    @Override
    public List<MuleModule> discover() {
        HashSet<String> packages = new HashSet<String>(1024);
        HashSet<String> resources = new HashSet<String>(1024);
        ArrayList<ExportedService> services = new ArrayList<ExportedService>(128);
        JreExplorer.exploreJdk(packages, resources, services);
        if (logger.isDebugEnabled()) {
            logger.debug("Discovered JRE:\npackages: {}\nresources: {}\nservices: {}", new Object[]{packages, resources, services.stream().map(p -> p.getServiceInterface() + ":" + p.getResource().toString()).collect(Collectors.toList())});
        }
        MuleModule jdkModule = new MuleModule(JRE_MODULE_NAME, packages, resources, Collections.emptySet(), Collections.emptySet(), services);
        return Collections.singletonList(jdkModule);
    }
}

