/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.nativelib;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.SystemUtils;
import org.mule.runtime.deployment.model.internal.nativelib.NativeLibraryFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactCopyNativeLibraryFinder
implements NativeLibraryFinder {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String JNILIB_EXTENSION = ".jnilib";
    private final File artifactTempFolder;
    private final URL[] urls;

    public ArtifactCopyNativeLibraryFinder(File tempFolder, URL[] urls) {
        this.urls = urls;
        this.artifactTempFolder = new File(tempFolder, "native");
        if (this.artifactTempFolder.exists()) {
            this.cleanNativeLibs();
        } else if (!this.artifactTempFolder.mkdirs()) {
            throw new IllegalStateException(String.format("Unable to create application '%s' folder", this.artifactTempFolder.getAbsolutePath()));
        }
    }

    @Override
    public String findLibrary(String name, String parentLibraryPath) {
        String libraryPath = parentLibraryPath;
        if (null == libraryPath) {
            libraryPath = this.findLibraryLocally(name);
        }
        if (libraryPath != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("Found native library for '%s' on '%s", name, libraryPath));
            }
            File tempLibrary = this.copyNativeLibrary(name, libraryPath);
            libraryPath = tempLibrary.getAbsolutePath();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("Created native library copy for '%s' on '%s", name, libraryPath));
            }
        }
        return libraryPath;
    }

    private void cleanNativeLibs() {
        String[] list = this.artifactTempFolder.list();
        if (list != null) {
            for (String library : list) {
                new File(this.artifactTempFolder, library).delete();
            }
        }
    }

    private File copyNativeLibrary(String name, String libraryPath) {
        String nativeLibName = System.mapLibraryName(name);
        File tempLibrary = new File(this.artifactTempFolder, nativeLibName + System.currentTimeMillis());
        try {
            File library = new File(libraryPath);
            FileUtils.copyFile((File)library, (File)tempLibrary);
            return tempLibrary;
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Unable to generate copy for native library '%s' at '%s'", nativeLibName, tempLibrary.getAbsolutePath()), e);
        }
    }

    private String findLibraryLocally(String name) {
        String nativeLibName = System.mapLibraryName(name);
        String extension = FilenameUtils.getExtension((String)nativeLibName);
        Optional<URL> nativeLib = Arrays.stream(this.urls).filter(url -> {
            String fullPath;
            try {
                fullPath = url.toURI().toString();
            }
            catch (URISyntaxException e) {
                return false;
            }
            String baseName = FilenameUtils.getBaseName((String)fullPath);
            return baseName.contains(name) && (fullPath.endsWith(extension) || SystemUtils.IS_OS_MAC && fullPath.endsWith(JNILIB_EXTENSION));
        }).findFirst();
        if (nativeLib.isPresent()) {
            return nativeLib.get().getFile();
        }
        return null;
    }
}

