/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.soap.internal.runtime.operation;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.transformer.MessageTransformerException;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.extension.api.soap.SoapAttachment;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExtensionsClientArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.StreamingHelperArgumentResolver;
import org.mule.runtime.module.extension.soap.internal.runtime.connection.ForwardingSoapClient;
import org.mule.runtime.soap.api.client.SoapClient;
import org.mule.runtime.soap.api.exception.error.SoapExceptionEnricher;
import org.mule.runtime.soap.api.message.SoapRequest;
import org.mule.runtime.soap.api.message.SoapRequestBuilder;
import org.mule.runtime.soap.api.message.SoapResponse;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class SoapOperationExecutor
implements ComponentExecutor<OperationModel> {
    @Inject
    private MuleExpressionLanguage expressionExecutor;
    @Inject
    private TransformationService transformationService;
    @Inject
    private Registry registry;
    @Inject
    private PolicyManager policyManager;
    private final ConnectionArgumentResolver connectionResolver = new ConnectionArgumentResolver();
    private final StreamingHelperArgumentResolver streamingHelperArgumentResolver = new StreamingHelperArgumentResolver();
    private final SoapExceptionEnricher soapExceptionEnricher = new SoapExceptionEnricher();

    public Publisher<Object> execute(ExecutionContext<OperationModel> context) {
        try {
            String serviceId = (String)context.getParameter("service");
            ForwardingSoapClient connection = (ForwardingSoapClient)this.connectionResolver.resolve(context).get();
            Map<String, String> customHeaders = connection.getCustomHeaders(serviceId, this.getOperation(context));
            SoapRequest request = this.getRequest(context, customHeaders);
            SoapClient soapClient = connection.getSoapClient(serviceId);
            SoapResponse response = connection.getExtensionsClientDispatcher(() -> (ExtensionsClient)new ExtensionsClientArgumentResolver(this.registry, this.policyManager).resolve(context).get()).map(d -> soapClient.consume(request, d)).orElseGet(() -> soapClient.consume(request));
            return Mono.justOrEmpty((Object)response.getAsResult((StreamingHelper)this.streamingHelperArgumentResolver.resolve(context).get()));
        }
        catch (MessageTransformerException | TransformerException e) {
            return Mono.error((Throwable)e);
        }
        catch (Exception e) {
            return Mono.error((Throwable)this.soapExceptionEnricher.enrich(e));
        }
        catch (Throwable t) {
            return Mono.error((Throwable)Exceptions.wrapFatal((Throwable)t));
        }
    }

    private SoapRequest getRequest(ExecutionContext<OperationModel> context, Map<String, String> fixedHeaders) throws MessageTransformerException, TransformerException {
        SoapRequestBuilder builder = SoapRequest.builder().operation(this.getOperation(context));
        builder.soapHeaders(fixedHeaders);
        Optional optionalMessageGroup = this.getParam(context, "Message");
        if (optionalMessageGroup.isPresent()) {
            Map attachments;
            InputStream headers;
            Map message = (Map)optionalMessageGroup.get();
            InputStream body = (InputStream)message.get("body");
            if (body != null) {
                builder.content(body);
            }
            if ((headers = (InputStream)message.get("headers")) != null) {
                builder.soapHeaders((Map)this.evaluateHeaders(headers));
            }
            if ((attachments = (Map)message.get("attachments")) != null) {
                this.toSoapAttachments(attachments).forEach((arg_0, arg_1) -> ((SoapRequestBuilder)builder).attachment(arg_0, arg_1));
            }
        }
        this.getParam(context, "transportHeaders").ifPresent(th -> builder.transportHeaders((Map)th));
        return builder.build();
    }

    private String getOperation(ExecutionContext<OperationModel> context) {
        return (String)this.getParam(context, "operation").orElseThrow(() -> new IllegalStateException("Execution Context does not have the required operation parameter"));
    }

    private <T> Optional<T> getParam(ExecutionContext<OperationModel> context, String param) {
        return context.hasParameter(param) ? Optional.ofNullable(context.getParameter(param)) : Optional.empty();
    }

    private Object evaluateHeaders(InputStream headers) {
        String hs = IOUtils.toString((InputStream)headers);
        BindingContext context = BindingContext.builder().addBinding("payload", new TypedValue((Object)hs, DataType.XML_STRING)).build();
        return this.expressionExecutor.evaluate("%dw 2.0 \noutput application/java \n---\npayload.headers mapObject (value, key) -> {\n    '$key' : write((key): value, \"application/xml\")\n}", context).getValue();
    }

    private Map<String, SoapAttachment> toSoapAttachments(Map<String, TypedValue<?>> attachments) throws MessageTransformerException, TransformerException {
        HashMap<String, SoapAttachment> soapAttachmentMap = new HashMap<String, SoapAttachment>();
        for (Map.Entry<String, TypedValue<?>> attachment : attachments.entrySet()) {
            SoapAttachment soapAttachment = new SoapAttachment(this.toInputStream(attachment.getValue()), attachment.getValue().getDataType().getMediaType());
            soapAttachmentMap.put(attachment.getKey(), soapAttachment);
        }
        return soapAttachmentMap;
    }

    private InputStream toInputStream(TypedValue typedValue) throws MessageTransformerException, TransformerException {
        Object value = typedValue.getValue();
        if (value instanceof InputStream) {
            return (InputStream)value;
        }
        return (InputStream)this.transformationService.transform(value, DataType.fromObject((Object)value), DataType.INPUT_STREAM);
    }
}

