/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal;

import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.api.util.func.CheckedSupplier;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;

public class ExtensionResolvingContext {
    private LazyValue<Optional<ConfigurationInstance>> configurationInstance;
    private LazyValue<Optional<ConnectionHandler>> connectionHandler;

    public ExtensionResolvingContext(Supplier<Optional<ConfigurationInstance>> configurationSupplier, ConnectionManager connectionManager) {
        this.configurationInstance = new LazyValue(configurationSupplier);
        this.connectionHandler = new LazyValue((Supplier)((CheckedSupplier)() -> {
            Optional configurationInstance = (Optional)this.configurationInstance.get();
            if (configurationInstance.isPresent() && ((ConfigurationInstance)configurationInstance.get()).getConnectionProvider().isPresent()) {
                return Optional.ofNullable(connectionManager.getConnection(((ConfigurationInstance)configurationInstance.get()).getValue()));
            }
            return Optional.empty();
        }));
    }

    public <C> Optional<C> getConfig() {
        return ((Optional)this.configurationInstance.get()).map(ConfigurationInstance::getValue);
    }

    public <C> Optional<C> getConnection() throws ConnectionException {
        try {
            return ((Optional)this.connectionHandler.get()).map(ConnectionHandler::getConnection);
        }
        catch (Exception e) {
            Optional connectionException = ExceptionUtils.extractConnectionException((Throwable)e);
            throw connectionException.orElse(new ConnectionException((Throwable)e));
        }
    }

    public void dispose() {
        this.connectionHandler.ifComputed(optionalHandler -> optionalHandler.ifPresent(ConnectionHandler::release));
    }
}

