/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.execution.ArgumentResolverDelegate;
import org.mule.runtime.module.extension.internal.runtime.execution.MethodArgumentResolverDelegate;
import org.mule.runtime.module.extension.internal.runtime.execution.OperationArgumentResolverFactory;
import org.mule.runtime.module.extension.internal.runtime.operation.ReflectiveMethodOperationExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class ReflectiveMethodComponentExecutor<M extends ComponentModel>
implements MuleContextAware,
Lifecycle,
OperationArgumentResolverFactory<M> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectiveMethodOperationExecutor.class);
    private static final ArgumentResolverDelegate NO_ARGS_DELEGATE = new NoArgumentsResolverDelegate();
    private final Method method;
    private final Object componentInstance;
    private final ClassLoader extensionClassLoader;
    private final LazyValue<ArgumentResolverDelegate> argumentResolverDelegate;
    private MuleContext muleContext;

    public ReflectiveMethodComponentExecutor(List<ParameterGroupModel> groups, Method method, Object componentInstance) {
        this.method = method;
        this.componentInstance = componentInstance;
        this.argumentResolverDelegate = ArrayUtils.isEmpty((Object[])method.getParameterTypes()) ? new LazyValue<ArgumentResolverDelegate>((Object)NO_ARGS_DELEGATE) : this.getMethodArgumentResolver(groups, method);
        this.extensionClassLoader = method.getDeclaringClass().getClassLoader();
    }

    private LazyValue<ArgumentResolverDelegate> getMethodArgumentResolver(List<ParameterGroupModel> groups, Method method) {
        return new LazyValue(() -> {
            try {
                MethodArgumentResolverDelegate resolver = new MethodArgumentResolverDelegate(groups, method);
                LifecycleUtils.initialiseIfNeeded((Object)resolver, (MuleContext)this.muleContext);
                return resolver;
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not initialize argument resolver resolver"), (Throwable)e);
            }
        });
    }

    public Object execute(ExecutionContext<M> executionContext) {
        return ClassUtils.withContextClassLoader((ClassLoader)this.extensionClassLoader, () -> ReflectionUtils.invokeMethod((Method)this.method, (Object)this.componentInstance, (Object[])Arrays.stream(this.getParameterValues(executionContext, this.method.getParameterTypes())).map(LazyValue::get).toArray(Object[]::new)));
    }

    private LazyValue<Object>[] getParameterValues(ExecutionContext<M> executionContext, Class<?>[] parameterTypes) {
        return ((ArgumentResolverDelegate)this.argumentResolverDelegate.get()).resolve(executionContext, parameterTypes);
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.componentInstance, (boolean)true, (MuleContext)this.muleContext);
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded((Object)this.componentInstance);
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.componentInstance);
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.componentInstance, (Logger)LOGGER);
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        if (this.componentInstance instanceof MuleContextAware) {
            ((MuleContextAware)this.componentInstance).setMuleContext(context);
        }
    }

    @Override
    public Function<ExecutionContext<M>, Map<String, Object>> createArgumentResolver(M operationModel) {
        return ec -> (Map)ClassUtils.withContextClassLoader((ClassLoader)this.extensionClassLoader, () -> {
            LazyValue<Object>[] resolved = this.getParameterValues((ExecutionContext<M>)ec, this.method.getParameterTypes());
            HashMap<String, LazyValue<Object>> resolvedParams = new HashMap<String, LazyValue<Object>>();
            for (int i = 0; i < this.method.getParameterCount(); ++i) {
                resolvedParams.put(this.method.getParameters()[i].getName(), resolved[i]);
            }
            return resolvedParams;
        });
    }

    private static class NoArgumentsResolverDelegate
    implements ArgumentResolverDelegate {
        private static final LazyValue[] EMPTY = new LazyValue[0];

        private NoArgumentsResolverDelegate() {
        }

        @Override
        public LazyValue<Object>[] resolve(ExecutionContext executionContext, Class<?>[] parameterTypes) {
            return EMPTY;
        }
    }
}

