/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.extension.internal.loader.ExtensionModelLoaderManager;
import org.mule.runtime.module.launcher.MuleContainer;
import org.mule.runtime.module.launcher.coreextension.MuleCoreExtensionManagerServer;
import org.mule.runtime.module.launcher.log4j2.MuleLog4jContextFactory;
import org.mule.runtime.module.repository.api.RepositoryService;
import org.mule.runtime.module.service.ServiceManager;
import org.mule.runtime.module.tooling.api.ToolingService;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.size.SmallTest;

@SmallTest
public class MuleContainerTestCase
extends AbstractMuleTestCase {
    @Rule
    public SystemProperty simpleLog = new SystemProperty("mule.simpleLog", "true");
    private MuleContainer container;
    private MuleCoreExtensionManagerServer coreExtensionManager;
    private DeploymentService deploymentService = (DeploymentService)Mockito.mock(DeploymentService.class);
    private RepositoryService repositoryService = (RepositoryService)Mockito.mock(RepositoryService.class);
    private final ServiceManager serviceManager = (ServiceManager)Mockito.mock(ServiceManager.class);
    private final ExtensionModelLoaderManager extensionModelLoaderManager = (ExtensionModelLoaderManager)Mockito.mock(ExtensionModelLoaderManager.class);
    private ToolingService toolingService = (ToolingService)Mockito.mock(ToolingService.class);

    @Before
    public void setUp() throws Exception {
        this.coreExtensionManager = (MuleCoreExtensionManagerServer)Mockito.mock(MuleCoreExtensionManagerServer.class);
        this.container = new MuleContainer(this.deploymentService, this.repositoryService, this.toolingService, this.coreExtensionManager, this.serviceManager, this.extensionModelLoaderManager);
        FileUtils.deleteDirectory((File)MuleFoldersUtil.getExecutionFolder());
    }

    @Test
    public void startsMuleCoreExtensionManager() throws Exception {
        this.container.start(false);
        ((MuleCoreExtensionManagerServer)Mockito.verify((Object)this.coreExtensionManager)).setDeploymentService(this.deploymentService);
        ((MuleCoreExtensionManagerServer)Mockito.verify((Object)this.coreExtensionManager)).setRepositoryService(this.repositoryService);
        ((MuleCoreExtensionManagerServer)Mockito.verify((Object)this.coreExtensionManager)).setToolingService(this.toolingService);
        ((MuleCoreExtensionManagerServer)Mockito.verify((Object)this.coreExtensionManager)).initialise();
        ((MuleCoreExtensionManagerServer)Mockito.verify((Object)this.coreExtensionManager)).start();
    }

    @Test
    public void initializeCoreExtensionsBeforeStartingDeploymentService() throws Exception {
        this.container.start(false);
        InOrder ordered = Mockito.inOrder((Object[])new Object[]{this.coreExtensionManager, this.deploymentService});
        ((MuleCoreExtensionManagerServer)ordered.verify((Object)this.coreExtensionManager)).initialise();
        ((DeploymentService)ordered.verify((Object)this.deploymentService)).start();
    }

    @Test
    public void startsCoreExtensionsBeforeDeploymentService() throws Exception {
        this.container.start(false);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.coreExtensionManager, this.deploymentService});
        ((MuleCoreExtensionManagerServer)inOrder.verify((Object)this.coreExtensionManager)).start();
        ((DeploymentService)inOrder.verify((Object)this.deploymentService)).start();
    }

    @Test
    public void stopsCoreExtensionsBeforeDeploymentService() throws Exception {
        this.container.start(false);
        this.container.stop();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.coreExtensionManager, this.deploymentService});
        ((MuleCoreExtensionManagerServer)inOrder.verify((Object)this.coreExtensionManager)).stop();
        ((DeploymentService)inOrder.verify((Object)this.deploymentService)).stop();
    }

    @Test
    public void disposesCoreExtensionsAfterStoppingDeploymentService() throws Exception {
        this.container.start(false);
        this.container.stop();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.coreExtensionManager, this.deploymentService});
        ((DeploymentService)inOrder.verify((Object)this.deploymentService)).stop();
        ((MuleCoreExtensionManagerServer)inOrder.verify((Object)this.coreExtensionManager)).dispose();
    }

    @Test
    public void disposesLogContextFactory() throws Exception {
        LoggerContextFactory originalFactory = LogManager.getFactory();
        try {
            MuleLog4jContextFactory contextFactory = (MuleLog4jContextFactory)Mockito.mock(MuleLog4jContextFactory.class);
            LogManager.setFactory((LoggerContextFactory)contextFactory);
            this.container.stop();
            ((MuleLog4jContextFactory)Mockito.verify((Object)contextFactory)).dispose();
        }
        finally {
            LogManager.setFactory((LoggerContextFactory)originalFactory);
        }
    }

    @Test
    public void onStartCreateExecutionFolderIfDoesNotExists() throws Exception {
        this.container.start(false);
        Assert.assertThat((Object)MuleFoldersUtil.getExecutionFolder().exists(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void onStartAndExecutionFolderExistsDoNotFail() throws Exception {
        Assert.assertThat((Object)MuleFoldersUtil.getExecutionFolder().mkdirs(), (Matcher)Is.is((Object)true));
        this.container.start(false);
    }

    @Test
    public void startsServiceManagerBeforeDeploymentService() throws Exception {
        this.container.start(false);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.serviceManager, this.deploymentService});
        ((ServiceManager)inOrder.verify((Object)this.serviceManager)).start();
        ((DeploymentService)inOrder.verify((Object)this.deploymentService)).start();
    }

    @Test
    public void stopsServiceManagerAfterDeploymentService() throws Exception {
        this.container.start(false);
        this.container.stop();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.serviceManager, this.deploymentService});
        ((DeploymentService)inOrder.verify((Object)this.deploymentService)).stop();
        ((ServiceManager)inOrder.verify((Object)this.serviceManager)).stop();
    }
}

