/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher;

import java.io.File;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.BeforeClass;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.module.deployment.impl.internal.AbstractSplashScreenTestCase;
import org.mule.runtime.module.launcher.MuleContainerStartupSplashScreen;

public class MuleContainerStartupSplashScreenTestCase
extends AbstractSplashScreenTestCase<MuleContainerStartupSplashScreen> {
    private static final String FIRST_PATCH = "SE-4242-3.8.0.jar";
    private static final String SECOND_PATCH = "SE-9999-3.7.3.jar";
    private static final String LIBRARY_JAR = "library.jar";
    private static final String COMPLEX_LOG_PART = "* Mule services:                                                     *\n*  - myService.zip                                                   *\n* Applied patches:                                                   *\n*  - SE-4242-3.8.0.jar                                               *\n*  - SE-9999-3.7.3.jar                                               *\n*  - library.jar                                                     *\n* Mule system properties:                                            *\n";

    @BeforeClass
    public static void setUpPatches() {
        File libFolder = FileUtils.newFile((File)workingDirectory.getRoot(), (String)"lib/patches");
        libFolder.mkdirs();
        FileUtils.newFile((File)libFolder, (String)FIRST_PATCH).mkdir();
        FileUtils.newFile((File)libFolder, (String)LIBRARY_JAR).mkdir();
        FileUtils.newFile((File)libFolder, (String)SECOND_PATCH).mkdir();
        File servicesFolder = FileUtils.newFile((File)workingDirectory.getRoot(), (String)"services");
        servicesFolder.mkdir();
        FileUtils.newFile((File)servicesFolder, (String)"myService.zip").mkdir();
    }

    @Before
    public void setUp() {
        this.splashScreen = new MuleContainerStartupSplashScreen();
    }

    protected void setUpSplashScreen() {
        ((MuleContainerStartupSplashScreen)this.splashScreen).doBody();
    }

    protected Matcher<String> getSimpleLogMatcher() {
        return Matchers.not((Matcher)Matchers.containsString((String)COMPLEX_LOG_PART));
    }

    protected Matcher<String> getComplexLogMatcher() {
        return Matchers.containsString((String)COMPLEX_LOG_PART);
    }
}

