/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.repository.internal;

import java.io.File;
import java.util.List;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.repository.api.BundleNotFoundException;
import org.mule.runtime.module.repository.api.RepositoryConnectionException;
import org.mule.runtime.module.repository.api.RepositoryService;
import org.mule.runtime.module.repository.api.RepositoryServiceDisabledException;

public class DefaultRepositoryService
implements RepositoryService {
    private final RepositorySystem repositorySystem;
    private final DefaultRepositorySystemSession repositorySystemSession;
    private final List<RemoteRepository> remoteRepositories;

    DefaultRepositoryService(RepositorySystem repositorySystem, DefaultRepositorySystemSession repositorySystemSession, List<RemoteRepository> remoteRepositories) {
        this.repositorySystem = repositorySystem;
        this.repositorySystemSession = repositorySystemSession;
        this.remoteRepositories = remoteRepositories;
    }

    @Override
    public File lookupBundle(BundleDependency bundleDependency) {
        try {
            if (this.remoteRepositories.isEmpty()) {
                throw new RepositoryServiceDisabledException("Repository service has not been configured so it's disabled. To enable it you must configure the set of repositories to use using the system property: mule.repository.repositories");
            }
            DefaultArtifact artifact = this.toArtifact(bundleDependency);
            ArtifactRequest getArtifactRequest = new ArtifactRequest();
            getArtifactRequest.setRepositories(this.remoteRepositories);
            getArtifactRequest.setArtifact((Artifact)artifact);
            ArtifactResult artifactResult = this.repositorySystem.resolveArtifact((RepositorySystemSession)this.repositorySystemSession, getArtifactRequest);
            return artifactResult.getArtifact().getFile();
        }
        catch (ArtifactResolutionException e) {
            if (e.getCause() instanceof ArtifactNotFoundException) {
                throw new BundleNotFoundException(e);
            }
            throw new RepositoryConnectionException("There was a problem connecting to one of the repositories", e);
        }
    }

    private DefaultArtifact toArtifact(BundleDependency bundleDependency) {
        return new DefaultArtifact(bundleDependency.getDescriptor().getGroupId(), bundleDependency.getDescriptor().getArtifactId(), (String)bundleDependency.getDescriptor().getClassifier().orElse(null), bundleDependency.getDescriptor().getType(), bundleDependency.getDescriptor().getVersion());
    }
}

