/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.service.ServiceDefinition;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.service.FileSystemServiceProviderDiscoverer;
import org.mule.runtime.module.service.ServiceClassLoaderFactory;
import org.mule.runtime.module.service.ServiceDescriptor;
import org.mule.runtime.module.service.ServiceResolutionError;
import org.mule.runtime.module.service.builder.ServiceFileBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemPropertyTemporaryFolder;

public class FileSystemServiceProviderDiscovererTestCase
extends AbstractMuleTestCase {
    private final ServiceClassLoaderFactory serviceClassLoaderFactory = (ServiceClassLoaderFactory)Mockito.mock(ServiceClassLoaderFactory.class);
    @Rule
    public SystemPropertyTemporaryFolder temporaryFolder = new SystemPropertyTemporaryFolder("mule.home");
    private ArtifactClassLoader containerClassLoader = (ArtifactClassLoader)Mockito.mock(ArtifactClassLoader.class);

    @Before
    public void setUp() throws Exception {
        File servicesFolder = MuleFoldersUtil.getServicesFolder();
        MatcherAssert.assertThat((Object)servicesFolder.mkdir(), (Matcher)Matchers.is((Object)true));
        Mockito.when((Object)this.containerClassLoader.getClassLoader()).thenReturn((Object)((Object)((Object)this)).getClass().getClassLoader());
        Mockito.when((Object)this.containerClassLoader.getClassLoaderLookupPolicy()).thenReturn(Mockito.mock(ClassLoaderLookupPolicy.class));
    }

    @Test
    public void discoversNoServices() throws Exception {
        FileSystemServiceProviderDiscoverer serviceProviderDiscoverer = new FileSystemServiceProviderDiscoverer(this.containerClassLoader, (ArtifactClassLoaderFactory)this.serviceClassLoaderFactory);
        List discover = serviceProviderDiscoverer.discover();
        MatcherAssert.assertThat((Object)discover, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void discoversServices() throws Exception {
        this.installService("fooService", FooServiceProvider.class);
        this.installService("barService", BarServiceProvider.class);
        ArtifactClassLoader serviceClassLoader = (ArtifactClassLoader)Mockito.mock(ArtifactClassLoader.class);
        Mockito.when((Object)this.serviceClassLoaderFactory.create((String)org.mockito.Matchers.argThat((Matcher)Matchers.any(String.class)), (ServiceDescriptor)org.mockito.Matchers.argThat((Matcher)Matchers.any(ServiceDescriptor.class)), (ClassLoader)org.mockito.Matchers.argThat((Matcher)Matchers.any(ClassLoader.class)), (ClassLoaderLookupPolicy)org.mockito.Matchers.argThat((Matcher)Matchers.any(ClassLoaderLookupPolicy.class)))).thenReturn((Object)serviceClassLoader);
        FileSystemServiceProviderDiscoverer serviceProviderDiscoverer = new FileSystemServiceProviderDiscoverer(this.containerClassLoader, (ArtifactClassLoaderFactory)this.serviceClassLoaderFactory);
        List serviceProviders = serviceProviderDiscoverer.discover();
        MatcherAssert.assertThat((Object)serviceProviders.size(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)serviceProviders, (Matcher)Matchers.hasItem((Matcher)Matchers.instanceOf(FooServiceProvider.class)));
        MatcherAssert.assertThat((Object)serviceProviders, (Matcher)Matchers.hasItem((Matcher)Matchers.instanceOf(BarServiceProvider.class)));
    }

    @Test(expected=ServiceResolutionError.class)
    public void detectsCorruptServiceFile() throws Exception {
        this.installCorruptedService("fooService", FooServiceProvider.class);
        ArtifactClassLoader serviceClassLoader = (ArtifactClassLoader)Mockito.mock(ArtifactClassLoader.class);
        Mockito.when((Object)this.serviceClassLoaderFactory.create((String)org.mockito.Matchers.argThat((Matcher)Matchers.any(String.class)), (ServiceDescriptor)org.mockito.Matchers.argThat((Matcher)Matchers.any(ServiceDescriptor.class)), (ClassLoader)org.mockito.Matchers.argThat((Matcher)Matchers.any(ClassLoader.class)), (ClassLoaderLookupPolicy)org.mockito.Matchers.argThat((Matcher)Matchers.any(ClassLoaderLookupPolicy.class)))).thenReturn((Object)serviceClassLoader);
        FileSystemServiceProviderDiscoverer serviceProviderDiscoverer = new FileSystemServiceProviderDiscoverer(this.containerClassLoader, (ArtifactClassLoaderFactory)this.serviceClassLoaderFactory);
        serviceProviderDiscoverer.discover();
    }

    private void installService(String serviceName, Class<? extends ServiceProvider> providerClass) throws Exception {
        this.installService(serviceName, providerClass, false);
    }

    private void installCorruptedService(String serviceName, Class<? extends ServiceProvider> providerClass) throws Exception {
        this.installService(serviceName, providerClass, true);
    }

    private void installService(String serviceName, Class<? extends ServiceProvider> providerClass, boolean corrupted) throws Exception {
        ServiceFileBuilder fooService = new ServiceFileBuilder(serviceName).configuredWith("service.className", providerClass.getName());
        if (corrupted) {
            fooService.corrupted();
        }
        File installedService = new File(MuleFoldersUtil.getServicesFolder(), fooService.getArtifactFile().getName());
        FileUtils.moveFile((File)fooService.getArtifactFile(), (File)installedService);
    }

    public static class BarServiceProvider
    implements ServiceProvider {
        public List<ServiceDefinition> providedServices() {
            return Collections.emptyList();
        }
    }

    public static class FooServiceProvider
    implements ServiceProvider {
        public List<ServiceDefinition> providedServices() {
            return Collections.emptyList();
        }
    }
}

