/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.service.ServiceDefinition;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.module.service.ReflectionServiceResolver;
import org.mule.runtime.module.service.ServiceProviderResolutionHelper;
import org.mule.runtime.module.service.ServiceResolutionError;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class ReflectionServiceResolverTestCase
extends AbstractMuleTestCase {
    private final FooService fooService = (FooService)Mockito.mock(FooService.class);
    private final BarService barService = (BarService)Mockito.mock(BarService.class);
    private final ServiceProvider fooServiceProvider = this.createFooServiceProvider(this.fooService);
    private final ServiceProvider barServiceProvider = this.createBarServiceProvider(this.barService);

    @Test
    public void resolvesIndependentServices() throws Exception {
        ArrayList<ServiceProvider> serviceProviders = new ArrayList<ServiceProvider>();
        serviceProviders.add(this.fooServiceProvider);
        serviceProviders.add(this.barServiceProvider);
        ReflectionServiceResolver dependencyResolver = new ReflectionServiceResolver((ServiceProviderResolutionHelper)Mockito.mock(ServiceProviderResolutionHelper.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        List services = dependencyResolver.resolveServices(serviceProviders);
        MatcherAssert.assertThat((Object)services.size(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)services, (Matcher)Matchers.hasItem((Object)this.fooService));
        MatcherAssert.assertThat((Object)services, (Matcher)Matchers.hasItem((Object)this.barService));
    }

    @Test
    public void resolvesServiceOrderedDependency() throws Exception {
        ArrayList<ServiceProvider> serviceProviders = new ArrayList<ServiceProvider>();
        serviceProviders.add(this.barServiceProvider);
        serviceProviders.add(this.fooServiceProvider);
        this.doServiceDependencyTest(this.fooService, this.fooServiceProvider, this.barService, serviceProviders);
    }

    @Test
    public void resolvesServiceDisorderedDependency() throws Exception {
        ArrayList<ServiceProvider> serviceProviders = new ArrayList<ServiceProvider>();
        serviceProviders.add(this.fooServiceProvider);
        serviceProviders.add(this.barServiceProvider);
        this.doServiceDependencyTest(this.fooService, this.fooServiceProvider, this.barService, serviceProviders);
    }

    private void doServiceDependencyTest(FooService fooService, ServiceProvider fooServiceProvider, BarService barService, List<ServiceProvider> serviceProviders) throws ServiceResolutionError {
        ServiceProviderResolutionHelper providerResolutionHelper = (ServiceProviderResolutionHelper)Mockito.mock(ServiceProviderResolutionHelper.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)providerResolutionHelper.findServiceDependencies(fooServiceProvider)).thenReturn(Collections.singletonList(BarService.class));
        ReflectionServiceResolver dependencyResolver = new ReflectionServiceResolver(providerResolutionHelper);
        List services = dependencyResolver.resolveServices(serviceProviders);
        MatcherAssert.assertThat((Object)services.size(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat(services.get(0), (Matcher)Matchers.is((Object)barService));
        MatcherAssert.assertThat(services.get(1), (Matcher)Matchers.is((Object)fooService));
        ((ServiceProviderResolutionHelper)Mockito.verify((Object)providerResolutionHelper)).injectInstance((ServiceProvider)Mockito.same((Object)fooServiceProvider), Mockito.anyCollection());
    }

    @Test(expected=ServiceResolutionError.class)
    public void detectsUnresolvableServiceDependency() throws Exception {
        FooService fooService = (FooService)Mockito.mock(FooService.class);
        ServiceProvider fooServiceProvider = this.createFooServiceProvider(fooService);
        ArrayList<ServiceProvider> serviceProviders = new ArrayList<ServiceProvider>();
        serviceProviders.add(fooServiceProvider);
        ServiceProviderResolutionHelper providerResolutionHelper = (ServiceProviderResolutionHelper)Mockito.mock(ServiceProviderResolutionHelper.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)providerResolutionHelper.findServiceDependencies(fooServiceProvider)).thenReturn(Collections.singletonList(BarService.class));
        ReflectionServiceResolver dependencyResolver = new ReflectionServiceResolver(providerResolutionHelper);
        dependencyResolver.resolveServices(serviceProviders);
    }

    private ServiceProvider createBarServiceProvider(BarService barService) {
        ServiceProvider barServiceProvider = (ServiceProvider)Mockito.mock(ServiceProvider.class);
        ArrayList<ServiceDefinition> barServices = new ArrayList<ServiceDefinition>();
        barServices.add(new ServiceDefinition(BarService.class, (Service)barService));
        Mockito.when((Object)barServiceProvider.providedServices()).thenReturn(barServices);
        return barServiceProvider;
    }

    private ServiceProvider createFooServiceProvider(FooService fooService) {
        ServiceProvider fooServiceProvider = (ServiceProvider)Mockito.mock(ServiceProvider.class);
        ArrayList<ServiceDefinition> fooServices = new ArrayList<ServiceDefinition>();
        fooServices.add(new ServiceDefinition(FooService.class, (Service)fooService));
        Mockito.when((Object)fooServiceProvider.providedServices()).thenReturn(fooServices);
        return fooServiceProvider;
    }

    public static interface BarService
    extends Service {
    }

    public static interface FooService
    extends Service {
    }
}

