/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.config.spring.DefaultXmlGathererErrorHandlerFactory;
import org.mule.runtime.config.spring.ModuleDelegatingEntityResolver;
import org.mule.runtime.config.spring.MuleDocumentLoader;
import org.mule.runtime.config.spring.XmlGathererErrorHandler;
import org.mule.runtime.config.spring.XmlGathererErrorHandlerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class XmlConfigurationDocumentLoader {
    private static final int VALIDATION_XSD = 3;
    private static final int NO_VALIDATION = 0;
    private final XmlGathererErrorHandlerFactory xmlGathererErrorHandlerFactory;
    private final int validationMode;

    public static XmlConfigurationDocumentLoader schemaValidatingDocumentLoader() {
        return new XmlConfigurationDocumentLoader(new DefaultXmlGathererErrorHandlerFactory());
    }

    public static XmlConfigurationDocumentLoader schemaValidatingDocumentLoader(XmlGathererErrorHandlerFactory errorHandlerFactory) {
        return new XmlConfigurationDocumentLoader(errorHandlerFactory);
    }

    public static XmlConfigurationDocumentLoader noValidationDocumentLoader() {
        return new XmlConfigurationDocumentLoader(null);
    }

    private XmlConfigurationDocumentLoader(XmlGathererErrorHandlerFactory errorHandlerFactory) {
        this.validationMode = errorHandlerFactory != null ? 3 : 0;
        this.xmlGathererErrorHandlerFactory = errorHandlerFactory;
    }

    public Document loadDocument(String filename, InputStream inputStream) {
        return this.loadDocument(Collections.emptySet(), filename, inputStream);
    }

    public Document loadDocument(Set<ExtensionModel> extensions, String filename, InputStream inputStream) {
        Document document;
        XmlGathererErrorHandler errorHandler = this.createXmlGathererErrorHandler();
        try {
            document = new MuleDocumentLoader().loadDocument(new InputSource(inputStream), new ModuleDelegatingEntityResolver(extensions), errorHandler, this.validationMode, true);
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        if (this.validationMode == 3) {
            this.throwExceptionIfErrorsWereFound(errorHandler, filename);
        }
        return document;
    }

    private void throwExceptionIfErrorsWereFound(XmlGathererErrorHandler errorHandler, String filename) {
        List<SAXParseException> errors = errorHandler.getErrors();
        if (!errors.isEmpty()) {
            String subMessage = String.format(errors.size() == 1 ? "was '%s' error" : "were '%s' errors", errors.size());
            StringBuilder sb = new StringBuilder("There " + subMessage + " while parsing the given file" + (filename.isEmpty() ? "." : " '" + filename + "'."));
            sb.append(System.lineSeparator()).append("Full list:");
            errors.forEach(error -> sb.append(System.lineSeparator()).append(error));
            sb.append(System.lineSeparator());
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)sb.toString()));
        }
    }

    private XmlGathererErrorHandler createXmlGathererErrorHandler() {
        return this.validationMode == 3 ? this.xmlGathererErrorHandlerFactory.create() : null;
    }
}

