/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.dsl.model;

import com.google.common.collect.ImmutableList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;

public class DslElementModel<T> {
    private final T model;
    private final String value;
    private final DslElementSyntax dsl;
    private final boolean explicitInDsl;
    private final Set<DslElementModel> containedElements;
    private final ComponentConfiguration configuration;
    private final ComponentIdentifier identifier;

    private DslElementModel(T model, DslElementSyntax dsl, Set<DslElementModel> containedElements, ComponentConfiguration configuration, String value, boolean explicitInDsl) {
        this.dsl = dsl;
        this.model = model;
        this.containedElements = containedElements;
        this.configuration = configuration;
        this.value = value;
        this.identifier = this.createIdentifier();
        this.explicitInDsl = explicitInDsl;
    }

    public T getModel() {
        return this.model;
    }

    public DslElementSyntax getDsl() {
        return this.dsl;
    }

    public List<DslElementModel> getContainedElements() {
        return ImmutableList.copyOf(this.containedElements);
    }

    public Optional<ComponentIdentifier> getIdentifier() {
        return Optional.ofNullable(this.identifier);
    }

    public Optional<ComponentConfiguration> getConfiguration() {
        return Optional.ofNullable(this.configuration);
    }

    public Optional<String> getValue() {
        return Optional.ofNullable(this.value);
    }

    public boolean isExplicitInDsl() {
        return this.explicitInDsl;
    }

    public <E> Optional<DslElementModel<E>> findElement(ComponentIdentifier identifier) {
        if (this.identifier != null && this.identifier.equals(identifier)) {
            return Optional.of(this);
        }
        return this.find(e -> e.findElement(identifier));
    }

    public <E> Optional<DslElementModel<E>> findElement(String modelName) {
        if (this.dsl.getAttributeName().equals(modelName) || this.model instanceof NamedObject && ((NamedObject)this.model).getName().equals(modelName)) {
            return Optional.of(this);
        }
        return this.find(e -> e.findElement(modelName));
    }

    private ComponentIdentifier createIdentifier() {
        if (this.configuration != null) {
            return this.configuration.getIdentifier();
        }
        if (!this.dsl.supportsTopLevelDeclaration() && !this.dsl.supportsChildDeclaration()) {
            return null;
        }
        return ComponentIdentifier.builder().withName(this.dsl.getElementName()).withNamespace(this.dsl.getPrefix()).build();
    }

    private <E> Optional<DslElementModel<E>> find(Function<DslElementModel, Optional<DslElementModel>> finder) {
        return this.containedElements.stream().map(finder).filter(Optional::isPresent).map(Optional::get).map(e -> e).findFirst();
    }

    public static <M> Builder<M> builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public static final class Builder<M> {
        private M model;
        private String value;
        private DslElementSyntax dsl;
        private ComponentConfiguration configuration;
        private Set<DslElementModel> contained = new LinkedHashSet<DslElementModel>();
        private boolean explicitInDsl = true;

        private Builder() {
        }

        public Builder<M> withModel(M model) {
            this.model = model;
            return this;
        }

        public Builder<M> withDsl(DslElementSyntax dsl) {
            this.dsl = dsl;
            return this;
        }

        public Builder<M> containing(DslElementModel element) {
            this.contained.add(element);
            return this;
        }

        public Builder<M> withConfig(ComponentConfiguration element) {
            this.configuration = element;
            return this;
        }

        public Builder<M> withValue(String value) {
            this.value = value;
            return this;
        }

        public Builder<M> isExplicitInDsl(boolean explicit) {
            this.explicitInDsl = explicit;
            return this;
        }

        public DslElementModel<M> build() {
            if (this.configuration != null) {
                Optional configurationValue = this.configuration.getValue();
                if (configurationValue.isPresent() && !StringUtils.isBlank((String)((String)configurationValue.get()))) {
                    if (this.value == null) {
                        this.value = (String)configurationValue.get();
                    } else {
                        Preconditions.checkState((boolean)this.value.equals(configurationValue.get()), (String)"The same element cannot have two different values associated.");
                    }
                } else {
                    Preconditions.checkState((this.value == null ? 1 : 0) != 0, (String)"The same element cannot have two different values associated.");
                }
            }
            return new DslElementModel(this.model, this.dsl, this.contained, this.configuration, this.value, this.explicitInDsl);
        }
    }
}

