/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.parsers.collection;

import org.mule.runtime.config.spring.parsers.generic.AutoIdUtils;
import org.mule.runtime.config.spring.parsers.generic.ChildDefinitionParser;
import org.w3c.dom.Element;

public class ChildMapEntryDefinitionParser
extends ChildDefinitionParser {
    public static final String KEY = "key";
    public static final String VALUE = "value";

    public ChildMapEntryDefinitionParser(String mapName) {
        super(mapName, KeyValuePair.class);
    }

    public ChildMapEntryDefinitionParser(String mapName, String keyName, String valueName) {
        this(mapName);
        this.addAlias(keyName, KEY);
        this.addAlias(valueName, VALUE);
    }

    @Override
    public String getBeanName(Element e) {
        String parentId = this.getParentBeanName(e);
        if (!parentId.startsWith(".")) {
            parentId = "." + parentId;
        }
        return AutoIdUtils.uniqueValue(parentId + ":" + e.getLocalName());
    }

    public static class KeyValuePair {
        private String key;
        private Object value;

        public KeyValuePair() {
        }

        public KeyValuePair(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

