/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.internal;

import java.util.LinkedHashSet;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.config.spring.internal.SpringLifecycleCallback;
import org.mule.runtime.config.spring.internal.SpringRegistry;
import org.mule.runtime.config.spring.internal.SpringRegistryBootstrap;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.component.Component;
import org.mule.runtime.core.api.config.Config;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.runtime.core.api.el.ExpressionLanguageExtension;
import org.mule.runtime.core.api.el.ExtendedExpressionLanguageAdaptor;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleCallback;
import org.mule.runtime.core.api.lifecycle.LifecycleObject;
import org.mule.runtime.core.api.lifecycle.LifecyclePhase;
import org.mule.runtime.core.api.processor.AbstractMessageProcessorOwner;
import org.mule.runtime.core.api.processor.InterceptingMessageProcessor;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.registry.Registry;
import org.mule.runtime.core.api.routing.OutboundRouter;
import org.mule.runtime.core.api.security.SecurityManager;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transport.LegacyConnector;
import org.mule.runtime.core.api.util.queue.QueueManager;
import org.mule.runtime.core.internal.lifecycle.EmptyLifecycleCallback;
import org.mule.runtime.core.internal.lifecycle.RegistryLifecycleManager;
import org.mule.runtime.core.internal.lifecycle.phases.MuleContextDisposePhase;
import org.mule.runtime.core.internal.lifecycle.phases.MuleContextInitialisePhase;
import org.mule.runtime.core.internal.lifecycle.phases.MuleContextStartPhase;
import org.mule.runtime.core.internal.lifecycle.phases.MuleContextStopPhase;
import org.mule.runtime.core.internal.lifecycle.phases.NotInLifecyclePhase;
import org.mule.runtime.core.internal.routing.requestreply.AbstractAsyncRequestReplyRequester;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;

public class SpringRegistryLifecycleManager
extends RegistryLifecycleManager {
    public SpringRegistryLifecycleManager(String id, SpringRegistry springRegistry, MuleContext muleContext) {
        super(id, (Registry)springRegistry, muleContext);
    }

    protected void registerPhases(Registry registry) {
        EmptyLifecycleCallback emptyCallback = new EmptyLifecycleCallback();
        this.registerPhase("not in lifecycle", (LifecyclePhase)new NotInLifecyclePhase(), (LifecycleCallback)emptyCallback);
        this.registerPhase("initialise", (LifecyclePhase)new SpringContextInitialisePhase(), (LifecycleCallback)new SpringLifecycleCallback(this, (SpringRegistry)registry));
        this.registerPhase("start", (LifecyclePhase)new MuleContextStartPhase(), (LifecycleCallback)emptyCallback);
        this.registerPhase("stop", (LifecyclePhase)new MuleContextStopPhase(), (LifecycleCallback)emptyCallback);
        this.registerPhase("dispose", (LifecyclePhase)new SpringContextDisposePhase());
    }

    private boolean isNamedBean(String name) {
        return name != null && !name.startsWith("(inner bean)");
    }

    class SpringContextDisposePhase
    extends MuleContextDisposePhase {
        public SpringContextDisposePhase() {
            this.setIgnoredObjectTypes(new Class[]{Component.class, MessageSource.class, InterceptingMessageProcessor.class, OutboundRouter.class, MuleContext.class, ServerNotificationManager.class, Service.class});
        }

        public void applyLifecycle(Object o) throws LifecycleException {
            if (o instanceof SpringRegistry) {
                ((SpringRegistry)((Object)o)).doDispose();
            } else if (o instanceof Transformer) {
                String name = ((Transformer)o).getName();
                if (SpringRegistryLifecycleManager.this.isNamedBean(name)) {
                    super.applyLifecycle(o);
                }
            } else {
                super.applyLifecycle(o);
            }
        }
    }

    class SpringContextInitialisePhase
    extends MuleContextInitialisePhase {
        public SpringContextInitialisePhase() {
            LinkedHashSet<LifecycleObject> initOrderedObjects = new LinkedHashSet<LifecycleObject>();
            initOrderedObjects.add(new LifecycleObject(ObjectStoreManager.class));
            initOrderedObjects.add(new LifecycleObject(ExpressionLanguageExtension.class));
            initOrderedObjects.add(new LifecycleObject(ExtendedExpressionLanguageAdaptor.class));
            initOrderedObjects.add(new LifecycleObject(QueueManager.class));
            initOrderedObjects.add(new LifecycleObject(StreamingManager.class));
            initOrderedObjects.add(new LifecycleObject(ConfigurationProvider.class));
            initOrderedObjects.add(new LifecycleObject(Config.class));
            initOrderedObjects.add(new LifecycleObject(LegacyConnector.class));
            initOrderedObjects.add(new LifecycleObject(SecurityManager.class));
            initOrderedObjects.add(new LifecycleObject(FlowConstruct.class));
            initOrderedObjects.add(new LifecycleObject(Initialisable.class));
            this.setOrderedLifecycleObjects(initOrderedObjects);
            this.setIgnoredObjectTypes(new Class[]{ExtensionManager.class, SpringRegistry.class, SpringRegistryBootstrap.class, Component.class, MessageSource.class, InterceptingMessageProcessor.class, AbstractMessageProcessorOwner.class, MessagingExceptionHandler.class, AbstractAsyncRequestReplyRequester.class, OutboundRouter.class, MessageProcessorChain.class, MuleContext.class, Service.class});
        }

        public void applyLifecycle(Object o) throws LifecycleException {
            if (o instanceof Transformer) {
                String name = ((Transformer)o).getName();
                if (SpringRegistryLifecycleManager.this.isNamedBean(name)) {
                    super.applyLifecycle(o);
                }
            } else {
                super.applyLifecycle(o);
            }
        }
    }
}

