/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.api.dsl.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.runtime.config.api.dsl.processor.ConfigFile;

public final class ArtifactConfig {
    private String artifactName;
    private List<ConfigFile> configFiles = new ArrayList<ConfigFile>();
    private Map<String, String> artifactProperties;

    private ArtifactConfig() {
    }

    public String getArtifactName() {
        return this.artifactName;
    }

    public List<ConfigFile> getConfigFiles() {
        return Collections.unmodifiableList(this.configFiles);
    }

    public Map<String, String> getArtifactProperties() {
        return this.artifactProperties;
    }

    public static class Builder {
        private ArtifactConfig applicationConfig = new ArtifactConfig();

        public Builder setApplicationName(String applicationName) {
            this.applicationConfig.artifactName = applicationName;
            return this;
        }

        public Builder addConfigFile(ConfigFile configFile) {
            this.applicationConfig.configFiles.add(configFile);
            return this;
        }

        public Builder setArtifactProperties(Map<String, String> artifactProperties) {
            this.applicationConfig.artifactProperties = artifactProperties;
            return this;
        }

        public ArtifactConfig build() {
            return this.applicationConfig;
        }
    }
}

