/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.factories;

import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.mule.runtime.api.time.Time;
import org.mule.runtime.api.time.TimeSupplier;
import org.mule.runtime.core.api.config.DynamicConfigExpiration;
import org.mule.runtime.core.internal.config.ImmutableDynamicConfigExpiration;
import org.mule.runtime.core.internal.config.ImmutableExpirationPolicy;
import org.mule.runtime.dsl.api.component.AbstractComponentFactory;
import org.mule.runtime.extension.api.runtime.ExpirationPolicy;

public class DynamicConfigExpirationObjectFactory
extends AbstractComponentFactory<DynamicConfigExpiration> {
    @Inject
    private TimeSupplier timeSupplier;
    private final long frequency;
    private final TimeUnit timeUnit;
    private ExpirationPolicy expirationPolicy;

    public DynamicConfigExpirationObjectFactory(long frequency, TimeUnit timeUnit) {
        this.frequency = frequency;
        this.timeUnit = timeUnit;
    }

    public DynamicConfigExpiration doGetObject() throws Exception {
        return new ImmutableDynamicConfigExpiration(new Time(this.frequency, this.timeUnit), this.getExpirationPolicy());
    }

    public void setExpirationPolicy(ExpirationPolicy expirationPolicy) {
        this.expirationPolicy = expirationPolicy;
    }

    private ExpirationPolicy getExpirationPolicy() {
        if (this.expirationPolicy != null) {
            return this.expirationPolicy;
        }
        return ImmutableExpirationPolicy.getDefault((TimeSupplier)this.timeSupplier);
    }
}

