/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.spring.security.editors;

import java.beans.PropertyEditorSupport;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.method.MapBasedMethodSecurityMetadataSource;

public class MethodSecurityMetadataSourceEditor
extends PropertyEditorSupport {
    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        try {
            LinkedHashMap mappings = new LinkedHashMap();
            if (text != null) {
                if ((text = text.trim()).length() > 0) {
                    Properties props = new Properties();
                    props.load(new StringReader(text));
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        String[] attrArray;
                        String methodName = (String)entry.getKey();
                        ArrayList<SecurityConfig> cfgAttrs = new ArrayList<SecurityConfig>();
                        String atrs = (String)entry.getValue();
                        for (String attr : attrArray = atrs.split(",")) {
                            if ((attr = attr.trim()).length() <= 0) continue;
                            cfgAttrs.add(new SecurityConfig(attr));
                        }
                        mappings.put(methodName, cfgAttrs);
                    }
                }
                this.setValue(new MapBasedMethodSecurityMetadataSource(mappings));
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(MessageFormat.format("Error parsing {0}", text), ex);
        }
    }
}

