/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.archiver.ArchiverException;
import org.mule.extension.maven.ExtensionDescriptorMojo;
import org.mule.plugin.maven.AbstractPackagePluginMojo;
import org.mule.plugin.maven.ModuleArchiver;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class ExtensionPackageMojo
extends AbstractPackagePluginMojo {
    private static final String ICON_SVG = "icon.svg";
    private static final String EXPECTED_ICON_RELATIVE_PATH = File.separator + "icon" + File.separator + "icon.svg";

    protected void addToArchiver(ModuleArchiver archiver) throws MojoFailureException {
        super.addToArchiver(archiver);
        this.addClasses(archiver);
        this.addPluginDescriptor(archiver);
        this.addIcon(archiver);
    }

    private void addIcon(ModuleArchiver archiver) throws MojoFailureException {
        File iconFile = new File(this.project.getBasedir(), EXPECTED_ICON_RELATIVE_PATH);
        if (!iconFile.exists()) {
            this.getLog().warn((CharSequence)String.format("The icon [%s] was not found in the current project, a generic one will be used instead. To replace it with a custom icon put an SVG file under [%s]", iconFile.getAbsolutePath(), EXPECTED_ICON_RELATIVE_PATH));
            String resourceIcon = "generic-connector.svg";
            InputStream resource = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("generic-connector.svg");
            iconFile = new File(this.outputDirectory, ICON_SVG);
            if (!iconFile.exists()) {
                try {
                    Files.copy(resource, Paths.get(iconFile.getAbsolutePath(), new String[0]), new CopyOption[0]);
                }
                catch (IOException e) {
                    throw new MojoFailureException(String.format("There was an issue while copying the resource [%s]", "generic-connector.svg"), (Throwable)e);
                }
            }
        }
        archiver.addFile(iconFile, RESERVED_FOLDER_MULE_ARTIFACT + ICON_SVG);
    }

    private void addPluginDescriptor(ModuleArchiver archiver) throws MojoFailureException {
        Path path = ExtensionDescriptorMojo.descriptorPathOrFail(this.outputDirectory);
        archiver.addFile(path.toFile(), MULE_PLUGIN_JSON_JAR_DESTINATION);
    }

    protected void addDependencies(ModuleArchiver archiver) {
    }

    protected String getArtifactType() {
        return "jar";
    }

    protected String getArtifactClassifier() {
        return "mule-plugin";
    }

    protected void doAddArtifactProperties(File pluginPropertiesFile) throws MojoFailureException {
    }

    protected void addArtifactProperties(ModuleArchiver archiver) throws ArchiverException {
    }

    protected File getMuleArtifactFile() {
        return new File(this.outputDirectory, this.finalName + "-" + "mule-plugin" + ".jar");
    }
}

