/*
 * Decompiled with CFR 0.152.
 */
package org.mule.plugin.maven;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.plugin.maven.AbstractPackagePluginMojo;
import org.mule.plugin.maven.ModuleArchiver;

@Mojo(name="package-server-plugin", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class ServerPluginPackageMojo
extends AbstractPackagePluginMojo {
    private static final String MULE_SERVER_PLUGIN = "mule-server-plugin";
    @Parameter(defaultValue="${project.basedir}", readonly=true)
    private File baseDir;
    @Parameter
    protected String pluginClassName;

    protected void doAddArtifactProperties(File pluginPropertiesFile) throws MojoFailureException {
    }

    public static Path descriptorPathOrFail(File outputDirectory) throws MojoFailureException {
        Path path = Paths.get(outputDirectory.getAbsolutePath(), "classes" + File.separator + MULE_PLUGIN_JSON_JAR_DESTINATION);
        if (Files.notExists(path, new LinkOption[0])) {
            throw new MojoFailureException(String.format("Should not have reach this point, could not obtain descriptor file from [%s]", path));
        }
        return path;
    }

    protected void addToArchiver(ModuleArchiver archiver) throws MojoFailureException {
        super.addToArchiver(archiver);
        this.addClasses(archiver);
        this.addDescriptor(archiver);
    }

    private void addDescriptor(ModuleArchiver archiver) throws MojoFailureException {
        Path path = ServerPluginPackageMojo.descriptorPathOrFail(this.outputDirectory);
        archiver.addFile(path.toFile(), MULE_PLUGIN_JSON_JAR_DESTINATION);
    }

    protected File getMuleArtifactFile() {
        return new File(this.outputDirectory, this.finalName + "-" + MULE_SERVER_PLUGIN + ".jar");
    }

    protected String getArtifactClassifier() {
        return MULE_SERVER_PLUGIN;
    }
}

