/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.core.api.util.concurrent.Latch;
import org.mule.service.scheduler.ThreadType;
import org.mule.service.scheduler.internal.BaseDefaultSchedulerTestCase;
import org.mule.service.scheduler.internal.ThrottledScheduler;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.quartz.SchedulerException;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;

@Features(value={"Scheduler Throttling"})
public class ThrottledSchedulerThrottleTestCase
extends BaseDefaultSchedulerTestCase {
    private static final int THROTTLE_SIZE = 2;
    private ExecutorService outerExecutor;

    @Override
    @Before
    public void before() throws SchedulerException {
        super.before();
        this.outerExecutor = Executors.newSingleThreadExecutor();
    }

    @Override
    @After
    public void after() throws SchedulerException, InterruptedException {
        this.outerExecutor.shutdownNow();
        this.outerExecutor.awaitTermination(5L, TimeUnit.SECONDS);
        super.after();
    }

    @Test
    @Description(value="Tests that a task submitted in excess of 'maxConcurrentTasks' waits until another task finishes before executing.")
    public void throttledTask() throws InterruptedException {
        ScheduledExecutorService scheduler = this.createExecutor();
        Latch latch = new Latch();
        for (int i = 0; i < 2; ++i) {
            scheduler.execute(() -> this.awaitLatch((CountDownLatch)latch));
        }
        Future<?> throttledSubmission = this.outerExecutor.submit(() -> scheduler.execute(() -> {}));
        Thread.sleep(10L);
        Assert.assertThat((Object)throttledSubmission.isDone(), (Matcher)CoreMatchers.is((Object)false));
        latch.countDown();
        new PollingProber(100L, 10L).check((Probe)new JUnitLambdaProbe(() -> {
            Assert.assertThat((Object)throttledSubmission.isDone(), (Matcher)CoreMatchers.is((Object)true));
            return true;
        }));
    }

    @Override
    protected ScheduledExecutorService createExecutor() {
        return new ThrottledScheduler(BaseDefaultSchedulerTestCase.class.getSimpleName(), this.sharedExecutor, 1, (ScheduledExecutorService)this.sharedScheduledExecutor, this.sharedQuartzScheduler, ThreadType.CUSTOM, 2, () -> 5000L, EMPTY_SHUTDOWN_CALLBACK);
    }
}

