/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.service.scheduler.internal.config.ContainerThreadPoolsConfig;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class ThreadPoolsConfigTestCase
extends AbstractMuleTestCase {
    private static int cores = Runtime.getRuntime().availableProcessors();
    private static long mem = Runtime.getRuntime().maxMemory() / 1024L;
    @Rule
    public TemporaryFolder tempMuleHome = new TemporaryFolder();
    @Rule
    public ExpectedException expected = ExpectedException.none();
    private File schedulerConfigFile;

    @Before
    public void before() {
        File confDir = new File(this.tempMuleHome.getRoot(), "conf");
        confDir.mkdir();
        this.schedulerConfigFile = new File(confDir, "scheduler-pools.conf");
        System.setProperty("mule.home", this.tempMuleHome.getRoot().getAbsolutePath());
    }

    @After
    public void after() {
        System.clearProperty("mule.home");
    }

    protected Properties buildDefaultConfigProps() {
        Properties props = new Properties();
        props.setProperty("org.mule.runtime.scheduler.gracefulShutdownTimeout", "15000");
        props.setProperty(ContainerThreadPoolsConfig.CPU_LIGHT_PREFIX + "." + "threadPool.size", "2*cores");
        props.setProperty(ContainerThreadPoolsConfig.CPU_LIGHT_PREFIX + "." + "workQueue.size", "mem / (2*3*32)");
        props.setProperty(ContainerThreadPoolsConfig.IO_PREFIX + "." + "threadPool.coreSize", "cores");
        props.setProperty(ContainerThreadPoolsConfig.IO_PREFIX + "." + "threadPool.maxSize", "mem / (2*30*64)");
        props.setProperty(ContainerThreadPoolsConfig.IO_PREFIX + "." + "workQueue.size", "mem / (2*3*32)");
        props.setProperty(ContainerThreadPoolsConfig.IO_PREFIX + "." + "threadPool.threadKeepAlive", "30000");
        props.setProperty(ContainerThreadPoolsConfig.CPU_INTENSIVE_PREFIX + "." + "threadPool.size", "2*cores");
        props.setProperty(ContainerThreadPoolsConfig.CPU_INTENSIVE_PREFIX + "." + "workQueue.size", "mem / (2*3*32)");
        return props;
    }

    @Test
    public void noMuleHome() throws IOException, MuleException {
        System.clearProperty("mule.home");
        ContainerThreadPoolsConfig config = ContainerThreadPoolsConfig.loadThreadPoolsConfig();
        Assert.assertThat((Object)config.getGracefulShutdownTimeout().getAsLong(), (Matcher)CoreMatchers.is((Object)15000L));
        Assert.assertThat((Object)config.getCpuLightPoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)(2 * cores)));
        Assert.assertThat((Object)config.getCpuLightQueueSize().getAsInt(), (Matcher)CoreMatchers.is((Object)1024));
        Assert.assertThat((Object)config.getIoCorePoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)cores));
        Assert.assertThat((Object)config.getIoMaxPoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)256));
        Assert.assertThat((Object)config.getIoQueueSize().getAsInt(), (Matcher)CoreMatchers.is((Object)1024));
        Assert.assertThat((Object)config.getIoKeepAlive().getAsLong(), (Matcher)CoreMatchers.is((Object)30000L));
        Assert.assertThat((Object)config.getCpuIntensivePoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)(2 * cores)));
        Assert.assertThat((Object)config.getCpuIntensiveQueueSize().getAsInt(), (Matcher)CoreMatchers.is((Object)1024));
    }

    @Test
    public void noConfigFile() throws IOException, MuleException {
        ContainerThreadPoolsConfig config = ContainerThreadPoolsConfig.loadThreadPoolsConfig();
        Assert.assertThat((Object)config.getGracefulShutdownTimeout().getAsLong(), (Matcher)CoreMatchers.is((Object)15000L));
        Assert.assertThat((Object)config.getCpuLightPoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)(2 * cores)));
        Assert.assertThat((Object)config.getCpuLightQueueSize().getAsInt(), (Matcher)CoreMatchers.is((Object)1024));
        Assert.assertThat((Object)config.getIoCorePoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)cores));
        Assert.assertThat((Object)config.getIoMaxPoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)256));
        Assert.assertThat((Object)config.getIoQueueSize().getAsInt(), (Matcher)CoreMatchers.is((Object)1024));
        Assert.assertThat((Object)config.getIoKeepAlive().getAsLong(), (Matcher)CoreMatchers.is((Object)30000L));
        Assert.assertThat((Object)config.getCpuIntensivePoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)(2 * cores)));
        Assert.assertThat((Object)config.getCpuIntensiveQueueSize().getAsInt(), (Matcher)CoreMatchers.is((Object)1024));
    }

    @Test
    public void defaultConfig() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.store(new FileOutputStream(this.schedulerConfigFile), "defaultConfig");
        ContainerThreadPoolsConfig config = ContainerThreadPoolsConfig.loadThreadPoolsConfig();
        Assert.assertThat((Object)config.getGracefulShutdownTimeout().getAsLong(), (Matcher)CoreMatchers.is((Object)15000L));
        Assert.assertThat((Object)config.getCpuLightPoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)(2 * cores)));
        Assert.assertThat((Object)config.getCpuLightQueueSize().getAsInt(), (Matcher)CoreMatchers.is((Object)((int)(mem / 192L))));
        Assert.assertThat((Object)config.getIoCorePoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)cores));
        Assert.assertThat((Object)config.getIoMaxPoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)((int)(mem / 3840L))));
        Assert.assertThat((Object)config.getIoQueueSize().getAsInt(), (Matcher)CoreMatchers.is((Object)((int)(mem / 192L))));
        Assert.assertThat((Object)config.getIoKeepAlive().getAsLong(), (Matcher)CoreMatchers.is((Object)30000L));
        Assert.assertThat((Object)config.getCpuIntensivePoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)(2 * cores)));
        Assert.assertThat((Object)config.getCpuIntensiveQueueSize().getAsInt(), (Matcher)CoreMatchers.is((Object)((int)(mem / 192L))));
    }

    @Test
    public void defaultConfigSpaced() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.setProperty(ContainerThreadPoolsConfig.CPU_LIGHT_PREFIX + "." + "threadPool.coreSize", "2 *cores");
        props.setProperty(ContainerThreadPoolsConfig.CPU_LIGHT_PREFIX + "." + "workQueue.size", "mem/ (2* 3*32 )");
        props.setProperty(ContainerThreadPoolsConfig.IO_PREFIX + "." + "threadPool.maxSize", "cores* cores");
        props.setProperty(ContainerThreadPoolsConfig.IO_PREFIX + "." + "workQueue.size", "mem /( 2*3*32)");
        props.setProperty(ContainerThreadPoolsConfig.CPU_INTENSIVE_PREFIX + "." + "threadPool.coreSize", "2  *   cores");
        props.setProperty(ContainerThreadPoolsConfig.CPU_INTENSIVE_PREFIX + "." + "workQueue.size", "mem / ( 2*3*32) ");
        props.store(new FileOutputStream(this.schedulerConfigFile), "defaultConfigSpaced");
        ContainerThreadPoolsConfig config = ContainerThreadPoolsConfig.loadThreadPoolsConfig();
        Assert.assertThat((Object)config.getGracefulShutdownTimeout().getAsLong(), (Matcher)CoreMatchers.is((Object)15000L));
        Assert.assertThat((Object)config.getCpuLightPoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)(2 * cores)));
        Assert.assertThat((Object)config.getCpuLightQueueSize().getAsInt(), (Matcher)CoreMatchers.is((Object)((int)(mem / 192L))));
        Assert.assertThat((Object)config.getIoCorePoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)cores));
        Assert.assertThat((Object)config.getIoMaxPoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)(cores * cores)));
        Assert.assertThat((Object)config.getIoQueueSize().getAsInt(), (Matcher)CoreMatchers.is((Object)((int)(mem / 192L))));
        Assert.assertThat((Object)config.getIoKeepAlive().getAsLong(), (Matcher)CoreMatchers.is((Object)30000L));
        Assert.assertThat((Object)config.getCpuIntensivePoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)(2 * cores)));
        Assert.assertThat((Object)config.getCpuIntensiveQueueSize().getAsInt(), (Matcher)CoreMatchers.is((Object)((int)(mem / 192L))));
    }

    @Test
    public void withDecimalsConfig() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.setProperty(ContainerThreadPoolsConfig.CPU_LIGHT_PREFIX + "." + "threadPool.size", "0.5 *cores");
        props.setProperty(ContainerThreadPoolsConfig.IO_PREFIX + "." + "threadPool.maxSize", "mem / (2* 2.5 *32)");
        props.store(new FileOutputStream(this.schedulerConfigFile), "withDecimalsConfig");
        ContainerThreadPoolsConfig config = ContainerThreadPoolsConfig.loadThreadPoolsConfig();
        Assert.assertThat((Object)config.getCpuLightPoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)(cores / 2)));
        Assert.assertThat((Object)config.getIoMaxPoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)((int)((double)mem / 160.0))));
    }

    @Test
    public void withPlusAndMinusConfig() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.setProperty(ContainerThreadPoolsConfig.CPU_LIGHT_PREFIX + "." + "threadPool.size", "cores + cores");
        props.setProperty(ContainerThreadPoolsConfig.IO_PREFIX + "." + "threadPool.maxSize", "2 + cores");
        props.setProperty(ContainerThreadPoolsConfig.CPU_INTENSIVE_PREFIX + "." + "threadPool.size", "cores - 1");
        props.store(new FileOutputStream(this.schedulerConfigFile), "withPlusAndMinusConfig");
        ContainerThreadPoolsConfig config = ContainerThreadPoolsConfig.loadThreadPoolsConfig();
        Assert.assertThat((Object)config.getCpuLightPoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)(2 * cores)));
        Assert.assertThat((Object)config.getIoMaxPoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)(2 + cores)));
        Assert.assertThat((Object)config.getCpuIntensivePoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)(cores - 1)));
    }

    @Test
    public void withMultiplyAndDivisionConfig() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.setProperty(ContainerThreadPoolsConfig.CPU_LIGHT_PREFIX + "." + "threadPool.size", "cores * 2");
        props.setProperty(ContainerThreadPoolsConfig.IO_PREFIX + "." + "threadPool.maxSize", "cores / 0.5");
        props.store(new FileOutputStream(this.schedulerConfigFile), "withMultiplyAndDivisionConfig");
        ContainerThreadPoolsConfig config = ContainerThreadPoolsConfig.loadThreadPoolsConfig();
        Assert.assertThat((Object)config.getCpuLightPoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)(2 * cores)));
        Assert.assertThat((Object)config.getIoMaxPoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)(2 * cores)));
    }

    @Test
    public void withParenthesisConfig() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.setProperty(ContainerThreadPoolsConfig.CPU_LIGHT_PREFIX + "." + "workQueue.size", "cores * (1+1)");
        props.setProperty(ContainerThreadPoolsConfig.IO_PREFIX + "." + "workQueue.size", "(cores + 1) * 2");
        props.store(new FileOutputStream(this.schedulerConfigFile), "withParenthesisConfig");
        ContainerThreadPoolsConfig config = ContainerThreadPoolsConfig.loadThreadPoolsConfig();
        Assert.assertThat((Object)config.getCpuLightQueueSize().getAsInt(), (Matcher)CoreMatchers.is((Object)(2 * cores)));
        Assert.assertThat((Object)config.getIoQueueSize().getAsInt(), (Matcher)CoreMatchers.is((Object)(2 * (1 + cores))));
    }

    @Test
    public void expressionConfigFixed() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.setProperty(ContainerThreadPoolsConfig.CPU_LIGHT_PREFIX + "." + "threadPool.size", "2");
        props.setProperty(ContainerThreadPoolsConfig.IO_PREFIX + "." + "threadPool.maxSize", "8");
        props.setProperty(ContainerThreadPoolsConfig.CPU_INTENSIVE_PREFIX + "." + "threadPool.size", "4");
        props.store(new FileOutputStream(this.schedulerConfigFile), "expressionConfigFixed");
        ContainerThreadPoolsConfig config = ContainerThreadPoolsConfig.loadThreadPoolsConfig();
        Assert.assertThat((Object)config.getCpuLightPoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)config.getIoMaxPoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)8));
        Assert.assertThat((Object)config.getCpuIntensivePoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)4));
    }

    @Test
    public void expressionConfigNegative() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.setProperty(ContainerThreadPoolsConfig.CPU_LIGHT_PREFIX + "." + "threadPool.size", "cores - " + (cores + 1));
        props.store(new FileOutputStream(this.schedulerConfigFile), "expressionConfigNegative");
        this.expected.expect(DefaultMuleException.class);
        this.expected.expectMessage(CoreMatchers.is((Object)(ContainerThreadPoolsConfig.CPU_LIGHT_PREFIX + "." + "threadPool.size" + ": Value has to be greater than 0")));
        ContainerThreadPoolsConfig.loadThreadPoolsConfig();
    }

    @Test
    public void zeroWorkQueueSize() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.setProperty(ContainerThreadPoolsConfig.CPU_LIGHT_PREFIX + "." + "workQueue.size", "0");
        props.store(new FileOutputStream(this.schedulerConfigFile), "expressionConfigNegative");
        ContainerThreadPoolsConfig config = ContainerThreadPoolsConfig.loadThreadPoolsConfig();
        Assert.assertThat((Object)config.getCpuLightQueueSize().getAsInt(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void invalidExpressionConfig() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.setProperty(ContainerThreadPoolsConfig.CPU_LIGHT_PREFIX + "." + "threadPool.size", "invalid");
        props.store(new FileOutputStream(this.schedulerConfigFile), "invalidExpressionConfig");
        this.expected.expect(DefaultMuleException.class);
        this.expected.expectMessage(CoreMatchers.is((Object)(ContainerThreadPoolsConfig.CPU_LIGHT_PREFIX + "." + "threadPool.size" + ": Expression not valid")));
        ContainerThreadPoolsConfig.loadThreadPoolsConfig();
    }

    @Test
    public void nastyExpressionConfig() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.setProperty(ContainerThreadPoolsConfig.CPU_LIGHT_PREFIX + "." + "threadPool.size", "; print('aha!')");
        props.store(new FileOutputStream(this.schedulerConfigFile), "nastyExpressionConfig");
        this.expected.expect(DefaultMuleException.class);
        this.expected.expectMessage(CoreMatchers.is((Object)(ContainerThreadPoolsConfig.CPU_LIGHT_PREFIX + "." + "threadPool.size" + ": Expression not valid")));
        ContainerThreadPoolsConfig.loadThreadPoolsConfig();
    }

    @Test
    public void invalidShutdownTimeConfig() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.setProperty("org.mule.runtime.scheduler.gracefulShutdownTimeout", "cores");
        props.store(new FileOutputStream(this.schedulerConfigFile), "invalidShutdownTimeConfig");
        this.expected.expect(DefaultMuleException.class);
        this.expected.expectCause(CoreMatchers.instanceOf(NumberFormatException.class));
        this.expected.expectMessage(CoreMatchers.is((Object)"org.mule.runtime.scheduler.gracefulShutdownTimeout: For input string: \"cores\""));
        ContainerThreadPoolsConfig.loadThreadPoolsConfig();
    }

    @Test
    public void invalidIoKeepAliveConfig() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.setProperty(ContainerThreadPoolsConfig.IO_PREFIX + "." + "threadPool.threadKeepAlive", "notANumber");
        props.store(new FileOutputStream(this.schedulerConfigFile), "invalidIoKeepAliveConfig");
        this.expected.expect(DefaultMuleException.class);
        this.expected.expectCause(CoreMatchers.instanceOf(NumberFormatException.class));
        this.expected.expectMessage(CoreMatchers.is((Object)(ContainerThreadPoolsConfig.IO_PREFIX + "." + "threadPool.threadKeepAlive" + ": For input string: \"notANumber\"")));
        ContainerThreadPoolsConfig.loadThreadPoolsConfig();
    }

    @Test
    public void negativeShutdownTimeConfig() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.setProperty("org.mule.runtime.scheduler.gracefulShutdownTimeout", "-1");
        props.store(new FileOutputStream(this.schedulerConfigFile), "negativeShutdownTimeConfig");
        this.expected.expect(DefaultMuleException.class);
        this.expected.expectMessage(CoreMatchers.is((Object)"org.mule.runtime.scheduler.gracefulShutdownTimeout: Value has to be greater than or equal to 0"));
        ContainerThreadPoolsConfig.loadThreadPoolsConfig();
    }

    @Test
    public void negativeIoKeepAliveConfig() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.setProperty(ContainerThreadPoolsConfig.IO_PREFIX + "." + "threadPool.threadKeepAlive", "-2");
        props.store(new FileOutputStream(this.schedulerConfigFile), "negativeIoKeepAliveConfig");
        this.expected.expect(DefaultMuleException.class);
        this.expected.expectMessage(CoreMatchers.is((Object)(ContainerThreadPoolsConfig.IO_PREFIX + "." + "threadPool.threadKeepAlive" + ": Value has to be greater than or equal to 0")));
        ContainerThreadPoolsConfig.loadThreadPoolsConfig();
    }

    @Test
    public void unevenParenthesis() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.setProperty(ContainerThreadPoolsConfig.IO_PREFIX + "." + "workQueue.size", "(-2");
        props.store(new FileOutputStream(this.schedulerConfigFile), "unevenParenthesis");
        this.expected.expect(DefaultMuleException.class);
        this.expected.expectMessage(CoreMatchers.startsWith((String)(ContainerThreadPoolsConfig.IO_PREFIX + "." + "workQueue.size" + ": <eval>:1:3 Expected ) but found eof")));
        ContainerThreadPoolsConfig.loadThreadPoolsConfig();
    }
}

