/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal.executor;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.core.api.scheduler.SchedulerBusyException;

public class WaitPolicy
implements RejectedExecutionHandler {
    private final long time;
    private final TimeUnit timeUnit;

    public WaitPolicy() {
        this(Long.MAX_VALUE, TimeUnit.SECONDS);
    }

    public WaitPolicy(long time, TimeUnit timeUnit) {
        this.time = time < 0L ? Long.MAX_VALUE : time;
        this.timeUnit = timeUnit;
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        try {
            if (!e.getQueue().offer(r, this.time, this.timeUnit)) {
                throw new SchedulerBusyException(String.format("Scheduler did not accept within %1d %2s", new Object[]{this.time, this.timeUnit}));
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RejectedExecutionException(ie);
        }
    }
}

