/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.service.scheduler.internal.BaseDefaultSchedulerTestCase;
import org.mule.service.scheduler.internal.DefaultScheduler;
import org.mule.service.scheduler.internal.RunnableRepeatableFutureDecorator;

public class RunnableRepeatableFutureDecoratorTestCase
extends BaseDefaultSchedulerTestCase {
    private DefaultScheduler scheduler;
    private RunnableRepeatableFutureDecorator<Object> taskDecorator;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.scheduler = (DefaultScheduler)this.createExecutor();
    }

    @Override
    @After
    public void after() throws Exception {
        this.scheduler.stop();
        this.scheduler = null;
        super.after();
    }

    @Test
    public void exceptionInWrapUpCallbackCompletesWrapUp() {
        ClassLoader taskClassloader = (ClassLoader)Mockito.mock(ClassLoader.class);
        this.taskDecorator = new RunnableRepeatableFutureDecorator(() -> new FutureTask<Object>(() -> null), d -> {
            throw new WrapUpException();
        }, taskClassloader, this.scheduler, "testTask", -1);
        this.taskDecorator.run();
        Assert.assertThat((Object)this.taskDecorator.isStarted(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)Thread.currentThread().getContextClassLoader(), (Matcher)Matchers.not((Object)taskClassloader));
    }

    @Test
    public void repeatableSecondRunBeforeFirstWrapUp() {
        AtomicInteger runCount = new AtomicInteger(0);
        this.taskDecorator = new RunnableRepeatableFutureDecorator(() -> new FutureTask<Object>(() -> {
            runCount.incrementAndGet();
            return null;
        }), d -> {
            if (runCount.get() < 2) {
                this.taskDecorator.run();
            }
        }, RunnableRepeatableFutureDecoratorTestCase.class.getClassLoader(), this.scheduler, "testTask", -1);
        this.taskDecorator.run();
        Assert.assertThat((Object)this.taskDecorator.isStarted(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)runCount.get(), (Matcher)Matchers.is((Object)2));
    }

    private static class WrapUpException
    extends RuntimeException {
        private static final long serialVersionUID = 5170908600838156528L;

        private WrapUpException() {
        }
    }
}

