/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import io.qameta.allure.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerPoolsConfig;
import org.mule.service.scheduler.internal.config.ContainerThreadPoolsConfig;
import org.mule.service.scheduler.internal.threads.SchedulerThreadPools;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

@Feature(value="Scheduler Service")
@RunWith(value=Parameterized.class)
public class ThreadNameTestCase
extends AbstractMuleTestCase {
    private ContainerThreadPoolsConfig threadPoolsConfig;
    private SchedulerThreadPools service;
    private Function<SchedulerThreadPools, Scheduler> schedulerFactory;
    private Scheduler scheduler;
    private AtomicReference<Optional<AssertionError>> failureRef;
    private Function<Scheduler, Matcher<String>> prefixMatcher;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({service -> service.createCpuLightScheduler(SchedulerConfig.config().withName(ThreadNameTestCase.class.getSimpleName()), 1, () -> 1000L), scheduler -> Matchers.allOf((Matcher)Matchers.startsWith((String)"[MuleRuntime].cpuLight"), (Matcher)Matchers.endsWith((String)(ThreadNameTestCase.class.getSimpleName() + " @" + Integer.toHexString(scheduler.hashCode()))))}, {service -> service.createCustomScheduler(SchedulerConfig.config().withPrefix("owner").withMaxConcurrentTasks(1).withName(ThreadNameTestCase.class.getSimpleName()), 1, () -> 1000L), scheduler -> Matchers.allOf((Matcher[])new Matcher[]{Matchers.startsWith((String)("[owner]." + ThreadNameTestCase.class.getSimpleName()))})}, {service -> service.createCustomScheduler(SchedulerConfig.config().withMaxConcurrentTasks(1).withName(ThreadNameTestCase.class.getSimpleName()), 1, () -> 1000L), scheduler -> Matchers.allOf((Matcher[])new Matcher[]{Matchers.startsWith((String)ThreadNameTestCase.class.getSimpleName())})});
    }

    public ThreadNameTestCase(Function<SchedulerThreadPools, Scheduler> schedulerFactory, Function<Scheduler, Matcher<String>> prefixMatcher) {
        this.schedulerFactory = schedulerFactory;
        this.prefixMatcher = prefixMatcher;
    }

    @Before
    public void before() throws MuleException {
        this.threadPoolsConfig = ContainerThreadPoolsConfig.loadThreadPoolsConfig();
        this.service = new SchedulerThreadPools(ThreadNameTestCase.class.getName(), (SchedulerPoolsConfig)this.threadPoolsConfig);
        this.service.start();
        this.scheduler = this.schedulerFactory.apply(this.service);
        this.failureRef = new AtomicReference<Object>(null);
    }

    @After
    public void after() throws MuleException, InterruptedException {
        if (this.service == null) {
            return;
        }
        for (Scheduler scheduler : new ArrayList(this.service.getSchedulers())) {
            scheduler.stop();
        }
        this.service.stop();
    }

    @Test
    public void threadNameForOneShotTask() throws InterruptedException, ExecutionException, TimeoutException {
        this.scheduler.submit((Runnable)new ThreadNameAssertingRunnable(this.failureRef, this.prefixMatcher.apply(this.scheduler)));
        this.pollingCheck();
    }

    @Test
    public void threadNameForRepeatableTask() throws InterruptedException, ExecutionException, TimeoutException {
        this.scheduler.scheduleAtFixedRate((Runnable)new ThreadNameAssertingRunnable(this.failureRef, this.prefixMatcher.apply(this.scheduler)), 0L, 1L, TimeUnit.SECONDS);
        this.pollingCheck();
    }

    @Test
    public void threadNameForCronTask() throws InterruptedException, ExecutionException, TimeoutException {
        this.scheduler.scheduleWithCronExpression((Runnable)new ThreadNameAssertingRunnable(this.failureRef, this.prefixMatcher.apply(this.scheduler)), "* * * * * ?");
        this.pollingCheck();
    }

    private void pollingCheck() {
        new PollingProber().check((Probe)new JUnitLambdaProbe(() -> {
            this.failureRef.get().ifPresent(f -> {
                throw f;
            });
            return true;
        }));
    }

    private class ThreadNameAssertingRunnable
    implements Runnable {
        private AtomicReference<Optional<AssertionError>> failureRef;
        private Matcher<String> threadNameMatcher;

        public ThreadNameAssertingRunnable(AtomicReference<Optional<AssertionError>> failureRef, Matcher<String> threadNameMatcher) {
            this.failureRef = failureRef;
            this.threadNameMatcher = threadNameMatcher;
        }

        @Override
        public void run() {
            try {
                Assert.assertThat((Object)Thread.currentThread().getName(), this.threadNameMatcher);
                this.failureRef.set(Optional.empty());
            }
            catch (AssertionError e) {
                this.failureRef.set(Optional.of(e));
            }
        }
    }
}

