/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerPoolsConfig;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.service.scheduler.internal.BaseDefaultSchedulerTestCase;
import org.mule.service.scheduler.internal.SchedulerThreadPoolsTestCase;
import org.mule.service.scheduler.internal.config.ContainerThreadPoolsConfig;
import org.mule.service.scheduler.internal.executor.SchedulerTaskThrottledException;
import org.mule.service.scheduler.internal.threads.SchedulerThreadPools;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

@Feature(value="Scheduler Throttling")
public class ThrottledSchedulerThrottleTestCase
extends BaseDefaultSchedulerTestCase {
    private static final int THROTTLE_SIZE = 2;
    private static final int SINGLE_TASK_THROTTLE_SIZE = 1;
    private ExecutorService outerExecutor;
    private ContainerThreadPoolsConfig threadPoolsConfig;
    private SchedulerThreadPools service;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.outerExecutor = Executors.newSingleThreadExecutor();
        this.threadPoolsConfig = ContainerThreadPoolsConfig.loadThreadPoolsConfig();
        this.service = new SchedulerThreadPools(SchedulerThreadPoolsTestCase.class.getName(), (SchedulerPoolsConfig)this.threadPoolsConfig);
        this.service.start();
    }

    @Override
    @After
    public void after() throws Exception {
        if (this.service == null) {
            return;
        }
        for (Scheduler scheduler : new ArrayList(this.service.getSchedulers())) {
            scheduler.stop();
        }
        this.service.stop();
        this.outerExecutor.shutdownNow();
        this.outerExecutor.awaitTermination(5L, TimeUnit.SECONDS);
        super.after();
    }

    @Test
    @Description(value="Tests that a 'maxConcurrentTasks=1' configuration allows to execute a single task")
    public void oneConcurrentTaskSupported() throws InterruptedException {
        Scheduler scheduler = this.service.createIoScheduler(SchedulerConfig.config().withMaxConcurrentTasks(1), 1, () -> 5000L);
        Latch latch = new Latch();
        scheduler.submit(() -> latch.countDown());
        if (!latch.await(200L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"Task never executed");
        }
    }

    @Test
    @Description(value="Tests that the throttler count is cinsistent after task cancellation")
    public void interruptionUpdatesThrottleCounterCorrectly() throws InterruptedException, ExecutionException, TimeoutException {
        Scheduler scheduler = this.service.createIoScheduler(SchedulerConfig.config().withMaxConcurrentTasks(1), 1, () -> 5000L);
        Scheduler cpuLightScheduler = this.service.createCpuLightScheduler(SchedulerConfig.config(), 2, () -> 5000L);
        Future outerSubmit = cpuLightScheduler.submit(() -> this.lambda$interruptionUpdatesThrottleCounterCorrectly$5((ScheduledExecutorService)scheduler));
        outerSubmit.get(60L, TimeUnit.SECONDS);
    }

    private void doSchedule(ScheduledExecutorService scheduler, CountDownLatch latch2) {
        scheduler.submit(() -> {
            try {
                latch2.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
    }

    @Test
    @Description(value="Tests that a task submitted in excess of 'maxConcurrentTasks' waits until another task finishes before executing.")
    public void throttledTask() throws InterruptedException {
        Scheduler scheduler = this.service.createIoScheduler(SchedulerConfig.config().withMaxConcurrentTasks(2), 2, () -> 5000L);
        Latch latch = new Latch();
        for (int i = 0; i < 2; ++i) {
            scheduler.execute(() -> this.awaitLatch((CountDownLatch)latch));
        }
        Future<?> throttledSubmission = this.outerExecutor.submit(() -> ThrottledSchedulerThrottleTestCase.lambda$throttledTask$10((ScheduledExecutorService)scheduler));
        Thread.sleep(10L);
        Assert.assertThat((Object)throttledSubmission.isDone(), (Matcher)CoreMatchers.is((Object)false));
        latch.countDown();
        new PollingProber(100L, 10L).check((Probe)new JUnitLambdaProbe(() -> {
            Assert.assertThat((Object)throttledSubmission.isDone(), (Matcher)CoreMatchers.is((Object)true));
            return true;
        }));
    }

    @Test
    @Description(value="Tests that a task submitted in excess of 'maxConcurrentTasks' is rejected when called from a cpu-processing thread.")
    public void throttledTaskRejected() throws InterruptedException, ExecutionException, TimeoutException {
        Scheduler scheduler = this.service.createIoScheduler(SchedulerConfig.config().withMaxConcurrentTasks(1), 1, () -> 5000L);
        Latch latch = new Latch();
        for (int i = 0; i < 2; ++i) {
            scheduler.execute(() -> this.awaitLatch((CountDownLatch)latch));
        }
        Scheduler cpuLightScheduler = this.service.createCpuLightScheduler(SchedulerConfig.config(), 2, () -> 5000L);
        Future submittedTest = cpuLightScheduler.submit(() -> ThrottledSchedulerThrottleTestCase.lambda$throttledTaskRejected$16((ScheduledExecutorService)scheduler));
        submittedTest.get(1L, TimeUnit.SECONDS);
    }

    private static /* synthetic */ void lambda$throttledTaskRejected$16(ScheduledExecutorService scheduler) {
        try {
            scheduler.execute(() -> {});
            Assert.fail((String)"Expected the task to be rejected with a 'SchedulerTaskThrottledException'");
        }
        catch (SchedulerTaskThrottledException schedulerTaskThrottledException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void lambda$throttledTask$10(ScheduledExecutorService scheduler) {
        scheduler.execute(() -> {});
    }

    private /* synthetic */ void lambda$interruptionUpdatesThrottleCounterCorrectly$5(ScheduledExecutorService scheduler) {
        Future<?> submit = scheduler.submit(() -> {
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
        submit.cancel(true);
        CountDownLatch latch = new CountDownLatch(2);
        this.doSchedule(scheduler, latch);
        try {
            this.doSchedule(scheduler, latch);
            Assert.fail((String)"Not rejected");
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }
}

