/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal.executor;

import java.util.concurrent.atomic.AtomicInteger;
import org.mule.runtime.core.api.util.StringUtils;

class SleepyTask
implements Runnable {
    public static final AtomicInteger activeTasks = new AtomicInteger(0);
    private final String name;
    private final long sleepTime;

    public SleepyTask(String name, long sleepTime) {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("SleepyTask needs a name!");
        }
        this.name = name;
        this.sleepTime = sleepTime;
    }

    public String toString() {
        return this.getClass().getName() + '{' + this.name + ", " + this.sleepTime + '}';
    }

    @Override
    public void run() {
        activeTasks.incrementAndGet();
        try {
            Thread.sleep(this.sleepTime);
        }
        catch (InterruptedException iex) {
            Thread.currentThread().interrupt();
        }
        finally {
            activeTasks.decrementAndGet();
        }
    }
}

