/*
 * $Id$
 */

package com.javaforge.bobber.archetype.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Collection;
import java.util.Date;

/**
 * 
 *              Represents system variable to be put in the
 * Velocity Context
 *           
 * 
 * @version $Revision$ $Date$
 */
public class Variable implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field name
     */
    private String name;

    /**
     * Field description
     */
    private String description;

    /**
     * Field defvalue
     */
    private String defvalue;

    /**
     * Field variables
     */
    private java.util.List variables;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addVariable
     * 
     * @param variable
     */
    public void addVariable(Variable variable)
    {
        if ( !(variable instanceof Variable) )
        {
            throw new ClassCastException( "Variable.addVariables(variable) parameter must be instanceof " + Variable.class.getName() );
        }
        getVariables().add( variable );
        variable.createVariableAssociation( this );
    } //-- void addVariable(Variable) 

    /**
     * Method breakVariableAssociation
     * 
     * @param variable
     */
    public void breakVariableAssociation(Variable variable)
    {
        if ( ! getVariables().contains( variable ) )
        {
            throw new IllegalStateException( "variable isn't associated." );
        }
        
        getVariables().remove( variable );
    } //-- void breakVariableAssociation(Variable) 

    /**
     * Method createVariableAssociation
     * 
     * @param variable
     */
    public void createVariableAssociation(Variable variable)
    {
        Collection variables = getVariables();
        
        if ( getVariables().contains(variable) )
        {
            throw new IllegalStateException( "variable is already assigned." );
        }
        
        variables.add( variable );
    } //-- void createVariableAssociation(Variable) 

    /**
     * Get null
     */
    public String getDefvalue()
    {
        return this.defvalue;
    } //-- String getDefvalue() 

    /**
     * Get null
     */
    public String getDescription()
    {
        return this.description;
    } //-- String getDescription() 

    /**
     * Get null
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Method getVariables
     */
    public java.util.List getVariables()
    {
        if ( this.variables == null )
        {
            this.variables = new java.util.ArrayList();
        }
        
        return this.variables;
    } //-- java.util.List getVariables() 

    /**
     * Method removeVariable
     * 
     * @param variable
     */
    public void removeVariable(Variable variable)
    {
        if ( !(variable instanceof Variable) )
        {
            throw new ClassCastException( "Variable.removeVariables(variable) parameter must be instanceof " + Variable.class.getName() );
        }
        variable.breakVariableAssociation( this );
        getVariables().remove( variable );
    } //-- void removeVariable(Variable) 

    /**
     * Set null
     * 
     * @param defvalue
     */
    public void setDefvalue(String defvalue)
    {
        this.defvalue = defvalue;
    } //-- void setDefvalue(String) 

    /**
     * Set null
     * 
     * @param description
     */
    public void setDescription(String description)
    {
        this.description = description;
    } //-- void setDescription(String) 

    /**
     * Set null
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 

    /**
     * Set 
     *             Variables that depend on their parent
     * 
     * @param variables
     */
    public void setVariables(java.util.List variables)
    {
        this.variables = variables;
    } //-- void setVariables(java.util.List) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
