/*
 * $Id$
 */

package com.javaforge.bobber.archetype.model.io.xpp3;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import com.javaforge.bobber.archetype.model.BobberArchetype;
import com.javaforge.bobber.archetype.model.Template;
import com.javaforge.bobber.archetype.model.Variable;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Iterator;
import java.util.Locale;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

/**
 * Class BobberArchetypeXpp3Writer.
 * 
 * @version $Revision$ $Date$
 */
public class BobberArchetypeXpp3Writer {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field NAMESPACE
     */
    private String NAMESPACE;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method write
     * 
     * @param writer
     * @param bobberArchetype
     */
    public void write(Writer writer, BobberArchetype bobberArchetype)
        throws java.io.IOException
    {
        XmlSerializer serializer = new MXSerializer();
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  " );
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n" );
        serializer.setOutput( writer );
        serializer.startDocument( bobberArchetype.getModelEncoding(), null );
        writeBobberArchetype( bobberArchetype, "archetype", serializer );
        serializer.endDocument();
    } //-- void write(Writer, BobberArchetype) 

    /**
     * Method writeBobberArchetype
     * 
     * @param bobberArchetype
     * @param serializer
     * @param tagName
     */
    private void writeBobberArchetype(BobberArchetype bobberArchetype, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( bobberArchetype != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( bobberArchetype.getId() != null )
            {
                serializer.startTag( NAMESPACE, "id" ).text( bobberArchetype.getId() ).endTag( NAMESPACE, "id" );
            }
            if ( bobberArchetype.isAllowPartial() != false )
            {
                serializer.startTag( NAMESPACE, "allowPartial" ).text( String.valueOf( bobberArchetype.isAllowPartial() ) ).endTag( NAMESPACE, "allowPartial" );
            }
            if ( bobberArchetype.getVariables() != null && bobberArchetype.getVariables().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "variables" );
                for ( Iterator iter = bobberArchetype.getVariables().iterator(); iter.hasNext(); )
                {
                    Variable o = (Variable) iter.next();
                    writeVariable( o, "variable", serializer );
                }
                serializer.endTag( NAMESPACE, "variables" );
            }
            if ( bobberArchetype.getTemplates() != null && bobberArchetype.getTemplates().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "templates" );
                for ( Iterator iter = bobberArchetype.getTemplates().iterator(); iter.hasNext(); )
                {
                    Template o = (Template) iter.next();
                    writeTemplate( o, "template", serializer );
                }
                serializer.endTag( NAMESPACE, "templates" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeBobberArchetype(BobberArchetype, String, XmlSerializer) 

    /**
     * Method writeTemplate
     * 
     * @param template
     * @param serializer
     * @param tagName
     */
    private void writeTemplate(Template template, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( template != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( template.getFile() != null )
            {
                serializer.startTag( NAMESPACE, "file" ).text( template.getFile() ).endTag( NAMESPACE, "file" );
            }
            if ( template.getOutput() != null )
            {
                serializer.startTag( NAMESPACE, "output" ).text( template.getOutput() ).endTag( NAMESPACE, "output" );
            }
            if ( template.getDependsOnVar() != null )
            {
                serializer.startTag( NAMESPACE, "dependsOnVar" ).text( template.getDependsOnVar() ).endTag( NAMESPACE, "dependsOnVar" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeTemplate(Template, String, XmlSerializer) 

    /**
     * Method writeVariable
     * 
     * @param variable
     * @param serializer
     * @param tagName
     */
    private void writeVariable(Variable variable, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( variable != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( variable.getName() != null )
            {
                serializer.startTag( NAMESPACE, "name" ).text( variable.getName() ).endTag( NAMESPACE, "name" );
            }
            if ( variable.getDescription() != null )
            {
                serializer.startTag( NAMESPACE, "description" ).text( variable.getDescription() ).endTag( NAMESPACE, "description" );
            }
            if ( variable.getDefvalue() != null )
            {
                serializer.startTag( NAMESPACE, "defvalue" ).text( variable.getDefvalue() ).endTag( NAMESPACE, "defvalue" );
            }
            if ( variable.getVariables() != null && variable.getVariables().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "variables" );
                for ( Iterator iter = variable.getVariables().iterator(); iter.hasNext(); )
                {
                    Variable o = (Variable) iter.next();
                    writeVariable( o, "variable", serializer );
                }
                serializer.endTag( NAMESPACE, "variables" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeVariable(Variable, String, XmlSerializer) 


}
