/*
 * Decompiled with CFR 0.152.
 */
package com.javaforge.bobber.plugin.archetype;

import com.javaforge.bobber.archetype.model.Template;
import com.javaforge.bobber.archetype.model.Variable;
import com.javaforge.bobber.archetype.model.io.xpp3.BobberArchetypeXpp3Reader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.maven.archetype.Archetype;
import org.apache.maven.archetype.ArchetypeDescriptorException;
import org.apache.maven.archetype.ArchetypeNotFoundException;
import org.apache.maven.archetype.ArchetypeTemplateProcessingException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.settings.MavenSettingsBuilder;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.codehaus.plexus.components.interactivity.InputHandler;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.codehaus.plexus.velocity.VelocityComponent;

public class BobberArchetype
extends AbstractLogEnabled
implements Archetype {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private VelocityComponent velocity;
    private ArtifactResolver artifactResolver;
    private InputHandler inputHandler;
    private ArtifactFactory artifactFactory;
    private MavenSettingsBuilder settingsBuilder;
    private static final int MESSAGE_LINE_LENGTH = 80;

    public void createArchetype(String archetypeGroupId, String archetypeArtifactId, String archetypeVersion, ArtifactRepository localRepository, List remoteRepositories, Map parameters) throws ArchetypeNotFoundException, ArchetypeDescriptorException, ArchetypeTemplateProcessingException {
        File outputDirectoryFile;
        com.javaforge.bobber.archetype.model.BobberArchetype archetype;
        JarFile archetypeJarFile;
        Artifact archetypeArtifact = this.artifactFactory.createArtifact(archetypeGroupId, archetypeArtifactId, archetypeVersion, "runtime", "jar");
        try {
            this.artifactResolver.resolve(archetypeArtifact, remoteRepositories, localRepository);
        }
        catch (ArtifactResolutionException e) {
            throw new ArchetypeDescriptorException("Error attempting to download archetype: " + e.getMessage(), (Throwable)e);
        }
        BobberArchetypeXpp3Reader builder = new BobberArchetypeXpp3Reader();
        try {
            archetypeJarFile = new JarFile(archetypeArtifact.getFile());
            ZipEntry zipEntry = archetypeJarFile.getEntry("META-INF/archetype.xml");
            InputStream is = archetypeJarFile.getInputStream(zipEntry);
            if (is == null) {
                throw new ArchetypeDescriptorException("The META-INF/archetype.xml descriptor cannot be found.");
            }
            archetype = builder.read(new InputStreamReader(is));
            archetypeJarFile.close();
        }
        catch (IOException e) {
            throw new ArchetypeDescriptorException("Error reading the META-INF/archetype.xml descriptor.", (Throwable)e);
        }
        catch (XmlPullParserException e) {
            throw new ArchetypeDescriptorException("Error reading the META-INF/archetype.xml descriptor.", (Throwable)e);
        }
        String basedir = (String)parameters.get("basedir");
        String artifactId = (String)parameters.get("artifactId");
        File pomFile = new File(basedir, "pom.xml");
        if (pomFile.exists() && archetype.isAllowPartial()) {
            outputDirectoryFile = new File(basedir);
        } else {
            outputDirectoryFile = new File(basedir, artifactId);
            if (!archetype.isAllowPartial() && outputDirectoryFile.exists() && outputDirectoryFile.listFiles().length > 0) {
                throw new ArchetypeTemplateProcessingException(outputDirectoryFile.getName() + " already exists - please run from a clean directory");
            }
            outputDirectoryFile.mkdir();
        }
        String outputDirectory = outputDirectoryFile.getAbsolutePath();
        VelocityContext context = new VelocityContext();
        String packageName = (String)parameters.get("package");
        this.addParamToContext("package", packageName, context);
        this.addParamToContext("packagePath", StringUtils.replace((String)packageName, (String)".", (String)"/"), context);
        for (Map.Entry entry : parameters.entrySet()) {
            this.addParamToContext((String)entry.getKey(), entry.getValue(), context);
        }
        boolean inInteractiveMode = false;
        try {
            inInteractiveMode = this.settingsBuilder.buildSettings().getInteractiveMode();
            String temp = System.getProperty("interactive", null);
            if (temp != null) {
                inInteractiveMode = Boolean.valueOf(temp);
            }
            this.getLogger().info("Interactive is: " + inInteractiveMode);
        }
        catch (Exception ie) {
            throw new ArchetypeTemplateProcessingException("unable to read settings ", (Throwable)ie);
        }
        if (inInteractiveMode) {
            this.getLogger().info("Please enter the values for the following archetype variables:");
        }
        List variables = archetype.getVariables();
        this.processVariables(variables.iterator(), context, inInteractiveMode);
        if (this.getLogger().isInfoEnabled()) {
            Object[] keys = context.getKeys();
            if (keys.length > 0) {
                this.getLogger().info("----------------------------------------------------------------------------");
                this.getLogger().info("Using following parameters for creating Archetype: " + archetypeArtifactId + ":" + archetypeVersion);
                this.getLogger().info("----------------------------------------------------------------------------");
                for (int i = 0; i < keys.length; ++i) {
                    String parameterName = (String)keys[i];
                    Object parameterValue = context.get(parameterName);
                    this.getLogger().info("Parameter: " + parameterName + " = " + parameterValue);
                }
            } else {
                this.getLogger().info("No Parameters found for creating Archetype");
            }
        }
        try {
            archetypeJarFile = new JarFile(archetypeArtifact.getFile());
            Enumeration<JarEntry> entries = archetypeJarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String path = entry.getName();
                if (!path.startsWith("archetype-resources") || path.endsWith(".vm")) continue;
                File t = new File(outputDirectory, path.substring(19));
                if (entry.isDirectory()) {
                    this.getLogger().debug("Extracting directory: " + entry.getName() + " to " + t.getAbsolutePath());
                    t.mkdir();
                    continue;
                }
                this.getLogger().debug("Extracting file: " + entry.getName() + " to " + t.getAbsolutePath());
                t.createNewFile();
                IOUtil.copy((InputStream)archetypeJarFile.getInputStream(entry), (OutputStream)new FileOutputStream(t));
            }
            archetypeJarFile.close();
            File t = new File(outputDirectory, "META-INF/archetype.xml");
            t.delete();
        }
        catch (IOException ioe) {
            throw new ArchetypeTemplateProcessingException("Error extracting archetype", (Throwable)ioe);
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            URL[] urls = new URL[]{archetypeArtifact.getFile().toURI().toURL()};
            URLClassLoader archetypeJarLoader = new URLClassLoader(urls);
            Thread.currentThread().setContextClassLoader(archetypeJarLoader);
            for (Template template : archetype.getTemplates()) {
                boolean shouldProcess = true;
                String condition = template.getDependsOnVar();
                String requiredValue = null;
                List options = new ArrayList();
                if (StringUtils.isNotEmpty((String)condition)) {
                    boolean not = false;
                    int x = condition.indexOf("!=");
                    this.getLogger().debug("Processing Condition : " + condition);
                    if (x > -1) {
                        not = true;
                        requiredValue = condition.substring(x + 2).trim();
                        options = this.getListOfValues(requiredValue);
                        condition = condition.substring(0, x).trim();
                    } else {
                        x = condition.indexOf("=");
                        if (x > -1) {
                            requiredValue = condition.substring(x + 1);
                            options = this.getListOfValues(requiredValue);
                            condition = condition.substring(0, x);
                        }
                    }
                    this.getLogger().debug("Not Expr: " + not);
                    this.getLogger().debug("Condition Value: '" + condition + "'");
                    this.getLogger().debug("Required Value: '" + requiredValue + "'");
                    Variable var = (Variable)this.findVariable(condition, variables);
                    if (var != null) {
                        String strValue = (String)context.get(var.getName());
                        this.getLogger().debug("Variable Value is: '" + strValue + "'");
                        if (requiredValue == null) {
                            if (!Boolean.valueOf(strValue).booleanValue()) {
                                shouldProcess = false;
                            }
                        } else if (!options.contains(strValue)) {
                            shouldProcess = false;
                        }
                    } else {
                        this.getLogger().debug("Variable Value is: null");
                        shouldProcess = false;
                    }
                    if (not) {
                        boolean bl = shouldProcess = !shouldProcess;
                    }
                }
                if (shouldProcess) {
                    this.processTemplate(template, outputDirectory, context);
                    continue;
                }
                this.getLogger().debug("Condition not met, skipping " + template.getOutput());
            }
        }
        catch (MalformedURLException mfe) {
            throw new ArchetypeTemplateProcessingException("Error loading archetype resources into the classpath", (Throwable)mfe);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Archetype created in dir: " + outputDirectory);
        }
    }

    protected void addParamToContext(String key, Object value, VelocityContext context) {
        this.getLogger().info("Adding Parameter to template Context: " + key + "=" + value);
        context.put(key, value);
    }

    protected void processVariables(Iterator variables, VelocityContext context, boolean interactiveMode) throws ArchetypeTemplateProcessingException {
        while (variables.hasNext()) {
            Variable var = (Variable)variables.next();
            String val = System.getProperty(var.getName(), var.getDefvalue());
            if (interactiveMode) {
                StringBuffer message = new StringBuffer();
                message.append(var.getName()).append(": ").append(NEW_LINE).append(StringUtils.repeat((String)"*", (int)80)).append(NEW_LINE).append(NEW_LINE).append(StringUtils.center((String)var.getDescription(), (int)80)).append(NEW_LINE).append(StringUtils.leftPad((String)("[default: " + val + "]"), (int)80)).append(NEW_LINE).append(StringUtils.repeat((String)"*", (int)80));
                this.getLogger().info(message.toString());
                try {
                    String answer = this.inputHandler.readLine();
                    if (!StringUtils.isEmpty((String)answer)) {
                        val = answer;
                    }
                }
                catch (IOException ie) {
                    throw new ArchetypeTemplateProcessingException((Throwable)ie);
                }
                context.put(var.getName(), (Object)val);
            } else {
                context.put(var.getName(), (Object)val);
            }
            if (val.toLowerCase().equals("false") || val.toLowerCase().equals("n")) {
                if (var.getVariables() == null) continue;
                this.processVariables(var.getVariables().iterator(), context, false);
                continue;
            }
            if (var.getVariables() == null) continue;
            this.processVariables(var.getVariables().iterator(), context, interactiveMode);
        }
    }

    protected List getListOfValues(String s) {
        ArrayList<String> options = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(s, "|");
        while (stringTokenizer.hasMoreTokens()) {
            options.add(stringTokenizer.nextToken());
        }
        return options;
    }

    protected void processTemplate(Template template, String outputDirectory, VelocityContext context) throws ArchetypeTemplateProcessingException {
        File outFile;
        try {
            StringWriter wout = new StringWriter();
            this.velocity.getEngine().evaluate((Context)context, (Writer)wout, "output value", template.getOutput());
            outFile = new File(outputDirectory, wout.toString());
            this.getLogger().debug(outFile.getAbsolutePath());
            FileUtils.forceMkdir((File)outFile.getParentFile());
            this.getLogger().debug("Created directory: " + outFile.getParentFile() + ", Dir exists = " + outFile.getParentFile().exists());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ArchetypeTemplateProcessingException("error evaluating output file name " + template.getOutput(), (Throwable)e);
        }
        FileWriter writer = null;
        try {
            this.getLogger().info("Processing Template: " + template.getFile());
            String templateLocation = "archetype-resources/" + template.getFile();
            writer = new FileWriter(outFile);
            this.velocity.getEngine().mergeTemplate(templateLocation, (Context)context, (Writer)writer);
            ((Writer)writer).flush();
        }
        catch (Exception e) {
            try {
                throw new ArchetypeTemplateProcessingException("Error merging velocity templates", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                this.getLogger().info("Written Template to: " + outFile + ", file exists = " + outFile.exists());
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
        this.getLogger().info("Written Template to: " + outFile + ", file exists = " + outFile.exists());
        try {
            File templateFile = new File(outputDirectory, template.getFile());
            String templateDir = FileUtils.dirname((String)templateFile.getCanonicalPath());
            String outputDir = FileUtils.dirname((String)outFile.getCanonicalPath());
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("TemplateDir=" + templateDir);
                this.getLogger().debug("OutputDir=" + outputDir);
            }
            if (!outputDir.startsWith(templateDir)) {
                this.getLogger().debug("Deleting Template Dir:" + templateDir);
                FileUtils.forceDelete((String)templateDir);
            }
        }
        catch (IOException e) {
            throw new ArchetypeTemplateProcessingException("Failed to cleanup the working dir.", (Throwable)e);
        }
    }

    protected Object findVariable(String variableName, List variables) {
        for (int i = 0; i < variables.size(); ++i) {
            Object o;
            Variable var = (Variable)variables.get(i);
            if (variableName.equals(var.getName())) {
                return var;
            }
            if (var.getVariables() == null || (o = this.findVariable(variableName, var.getVariables())) == null) continue;
            return o;
        }
        return null;
    }
}

