/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.anttasks;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.FileUtils;
import org.mule.tools.anttasks.FileChecker;

public class MuleDeploy
extends Task {
    private static final String MULE_HOME_PROPERTY = "dir.mule.home";
    private File applicationFile;
    private File muleHome;

    public void setApplicationFile(File applicationFile) {
        this.applicationFile = applicationFile;
    }

    public void execute() throws BuildException {
        FileChecker checker = new FileChecker(this.getLocation());
        checker.checkFile(this.applicationFile, "application file", false, false);
        File home = this.getMuleHome();
        checker.checkFile(home, "mule home directory", true, false);
        File appsDir = new File(home, "apps");
        checker.checkFile(appsDir, "mule apps directory", true, true);
        try {
            File destFile = new File(appsDir, this.applicationFile.getName());
            FileUtils.getFileUtils().copyFile(this.applicationFile, destFile, null, true);
        }
        catch (IOException ex) {
            throw new BuildException(MessageFormat.format("Problem copying Mule application file {0} to {1}", this.applicationFile, appsDir), (Throwable)ex, this.getLocation());
        }
    }

    public File getMuleHome() {
        if (this.muleHome != null) {
            return this.muleHome;
        }
        String home = this.getProject().getProperty(MULE_HOME_PROPERTY);
        return home == null ? null : new File(home);
    }

    public void setMuleHome(File muleHome) {
        this.muleHome = muleHome;
    }
}

