/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ajax;

import java.util.Map;
import org.mule.api.MessagingException;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.MessageAdapter;
import org.mule.api.transport.PropertyScope;
import org.mule.config.i18n.CoreMessages;
import org.mule.message.DefaultMuleMessageDTO;
import org.mule.module.json.filters.IsJsonFilter;
import org.mule.module.json.transformers.JsonToObject;
import org.mule.transport.AbstractMessageAdapter;

public class AjaxMessageAdapter
extends AbstractMessageAdapter {
    public static final String PAYLOAD_PARAM = "payload";
    public static final String REPLYTO_PARAM = "replyTo";
    protected transient JsonToObject transformer;
    protected transient IsJsonFilter filter = new IsJsonFilter();
    protected Object payload;

    public AjaxMessageAdapter(Object message) throws MessagingException {
        this.init(message);
    }

    public AjaxMessageAdapter(Object message, MessageAdapter template) throws MessagingException {
        super(template);
        this.init(message);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void init(Object message) throws MessagingException {
        if (message instanceof Map) {
            Map map = (Map)message;
            Object p = map.remove(PAYLOAD_PARAM);
            if (p == null) throw new IllegalArgumentException("payload parameter not set");
            if (this.filter.accept(p)) {
                this.transformer = new JsonToObject();
                this.transformer.setReturnClass(Map.class);
                try {
                    this.payload = this.transformer.transform(p);
                }
                catch (TransformerException e) {
                    throw new MessagingException(CoreMessages.transformFailed((String)message.getClass().getName(), (String)Map.class.getName()), message, (Throwable)e);
                }
            } else {
                this.payload = p;
            }
            this.setReplyTo(map.remove(REPLYTO_PARAM));
            if (map.size() <= 0) return;
            this.addProperties(map, PropertyScope.INVOCATION);
            return;
        }
        if (this.filter.accept(message)) {
            if (message.toString().indexOf(PAYLOAD_PARAM) > -1) {
                this.transformer = new JsonToObject();
                this.transformer.setReturnClass(DefaultMuleMessageDTO.class);
                DefaultMuleMessageDTO dto = null;
                try {
                    dto = (DefaultMuleMessageDTO)this.transformer.transform(message);
                }
                catch (TransformerException e) {
                    throw new MessagingException(CoreMessages.transformFailed((String)message.getClass().getName(), (String)DefaultMuleMessageDTO.class.getName()), message, (Throwable)e);
                }
                this.payload = dto.getPayload();
                dto.addPropertiesTo((MessageAdapter)this);
                return;
            }
            this.transformer = new JsonToObject();
            this.transformer.setReturnClass(Map.class);
            try {
                this.payload = this.transformer.transform(message);
                return;
            }
            catch (TransformerException e) {
                throw new MessagingException(CoreMessages.transformFailed((String)message.getClass().getName(), (String)DefaultMuleMessageDTO.class.getName()), message, (Throwable)e);
            }
        }
        this.payload = message;
    }

    public Object getPayload() {
        return this.payload;
    }
}

