/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ajax.container;

import javax.servlet.ServletException;
import org.mortbay.cometd.continuation.ContinuationCometdServlet;
import org.mule.RegistryContext;
import org.mule.api.MuleException;
import org.mule.api.transport.Connector;
import org.mule.transport.ajax.container.AjaxServletConnector;
import org.mule.transport.ajax.i18n.AjaxMessages;
import org.mule.transport.service.TransportFactory;

public class MuleAjaxServlet
extends ContinuationCometdServlet {
    public static final String COMETD_CONNECTOR_NAME_PROPERTY = "org.mule.ajax.connector.name";
    protected AjaxServletConnector connector = null;

    public void init() throws ServletException {
        super.init();
        String servletConnectorName = this.getServletConfig().getInitParameter(COMETD_CONNECTOR_NAME_PROPERTY);
        if (servletConnectorName == null) {
            this.connector = (AjaxServletConnector)TransportFactory.getConnectorByProtocol((String)"ajax-servlet");
            if (this.connector == null) {
                this.connector = new AjaxServletConnector();
                try {
                    RegistryContext.getRegistry().registerConnector((Connector)this.connector);
                }
                catch (MuleException e) {
                    throw new ServletException("Failed to register the AjaxServletConnector", (Throwable)e);
                }
            }
        } else {
            this.connector = (AjaxServletConnector)RegistryContext.getRegistry().lookupConnector(servletConnectorName);
            if (this.connector == null) {
                throw new ServletException(AjaxMessages.noAjaxConnectorWithName(servletConnectorName, COMETD_CONNECTOR_NAME_PROPERTY).toString());
            }
        }
        this.connector.setBayeux(this.getBayeux());
    }
}

